% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{auth}
\alias{auth}
\title{Crossref TDM authentication}
\description{
Crossref TDM authentication
}
\section{Authentication}{

There's a set of publishers that are involved in the Crossref
Text and Data Mining (TDM) program (http://tdmsupport.crossref.org/),
which means essentially the publishers
deposit URLs for fulltext in Crossref metadata.

Authentication is applicable only when the publisher you want to get
fulltext from requires it. OA publishers shouldn't need it as you'd
expect. There's many publishers that don't share links at all, so they are
irrelevant here.

For publishers that required authentication, the Crossref TDM
program allows for a single token to authenticate across publishers
(to make it easier for text miners). The publishers involved with the
authentication scheme are really only Elsevier and Wiley.

There's a how to guide for Crossref TDM at
\url{http://tdmsupport.crossref.org/researchers/}.
Get your Crossref TDM token by registering at
\url{https://apps.crossref.org/clickthrough/researchers}.
Save the token in your \code{.Renviron} file with a new row like
\verb{CROSSREF_TDM=your key}. We will read that key in for you - it's best
this way rather than passing in a key via a parameter - since you might
put that code up on the web somewhere and someone could use your key.
}

\section{IP addresses}{

If you don't know what IP addresses are, check out
\url{https://en.wikipedia.org/wiki/IP_address}. At least Elsevier and
I think Wiley also check your IP address in addition to requiring the
authentication token. Usually your're good if you're physically at the
institution that has access to the publishers content OR on a VPN
(i.e., pretending you're there).

If you forget about this, you'll get errors about not being authorized.
So check and make sure you're on a VPN if you're not physically
located at your institution.
}

\section{Fences}{

There's yet another issue to worry about. At least with Elsevier, they
have a so-called "fence" - that is, even if an institution has access
to Elsevier content, Elsevier doesn't necessarily have the fence
turned off - if its not off, you can't get through - if it's off, you can.
If you have the right token and you are sure you're on the right
IP address, this could be the problem for your lack of access.
}

\section{HELP!}{

If you're having trouble with any of this, get in touch with the
package maintainer.
}

