% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticNormalFixedMixture-class}
\alias{LogisticNormalFixedMixture-class}
\alias{.LogisticNormalFixedMixture}
\title{Standard logistic model with fixed mixture of multiple bivariate (log) normal priors}
\description{
This is standard logistic regression model with a mixture of multiple bivariate
(log) normal priors on the intercept and slope parameters. The weights of the
normal priors are fixed, hence no additional model parameters are introduced.
This type of prior is often used to better approximate a given posterior
distribution, or when the information is given in terms of a mixture.
}
\details{
The covariate is the natural logarithm of the dose \eqn{x} divided by
the reference dose \eqn{x^{*}}:

\deqn{logit[p(x)] = \alpha + \beta \cdot \log(x/x^{*})}
where \eqn{p(x)} is the probability of observing a DLT for a given dose
\eqn{x}.

The prior is
\deqn{(\alpha, \beta) \sim
\sum_{j=1}^{K} w_{j} Normal(\mu_{j}, \Sigma_{j})}
if a normal prior is used and
\deqn{(\alpha, \log(\beta)) \sim
\sum_{j=1}^{K} w_{j} Normal(\mu_{j}, \Sigma_{j})}
if a log normal prior is used.

The weight \eqn{w_{j}} of the components are fixed and sum to 1.

The (additional) slots of this class comprise two lists, containing the mean
vector, the covariance and precision matrices of the two bivariate normal
distributions each, the parameters of the beta prior for the first component
weight, as well as the reference dose. Moreover, a slot specifies whether a
log normal prior is used.
}
\section{Slots}{

\describe{
\item{\code{components}}{a list with one entry per component of the mixture.
Each entry is a list with \code{mean}, \code{cov} and \code{prec} for the
bivariate normal prior}

\item{\code{weights}}{the weights of the components, these must be positive and sum
to 1}

\item{\code{refDose}}{the reference dose \eqn{x^{*}}}

\item{\code{logNormal}}{is a log normal prior specified for each of the components?}
}}

\examples{

model <- LogisticNormalFixedMixture(components = 
                                      list(comp1 = list(mean = c(-0.85, 1),
                                                        cov = matrix(c(1, -0.5, -0.5, 1), 
                                                                     nrow = 2)),
                                           comp2 = list(mean = c(1, 1.5),
                                                        cov = matrix(c(1.2, -0.45, -0.45, 0.6), 
                                                                     nrow = 2))),
                                    weights = c(0.3,0.7),
                                    refDose = 50)


}
\keyword{classes}
