% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_client.R
\name{crew_client}
\alias{crew_client}
\title{Create a client object.}
\usage{
crew_client(
  name = NULL,
  workers = 1L,
  host = NULL,
  port = NULL,
  tls = crew::crew_tls(),
  tls_enable = NULL,
  tls_config = NULL,
  seconds_interval = 0.25,
  seconds_timeout = 10
)
}
\arguments{
\item{name}{Name of the client object. If \code{NULL}, a name is automatically
generated.}

\item{workers}{Integer, maximum number of parallel workers to run.}

\item{host}{IP address of the \code{mirai} client to send and receive tasks.
If \code{NULL}, the host defaults to the local IP address.}

\item{port}{TCP port to listen for the workers. If \code{NULL},
then an available ephemeral port is automatically chosen.}

\item{tls}{A TLS configuration object from \code{\link[=crew_tls]{crew_tls()}}.}

\item{tls_enable}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{tls_config}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete. If \code{space_poll} is \code{TRUE}, then
this is also the minimum number of seconds between calls to
\code{mirai::daemons()} for the purposes of checking worker status.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete.}
}
\description{
Create an \code{R6} wrapper object to manage the \code{mirai} client.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$log()
client$terminate()
}
}
\seealso{
Other developer: 
\code{\link{crew_async}()},
\code{\link{crew_controller}()},
\code{\link{crew_launcher}()}
}
\concept{developer}
