% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crev_deleted.R
\name{crev_deleted}
\alias{crev_deleted}
\title{Query Crossref Deleted Events data}
\usage{
crev_deleted(
  rows = 1000L,
  cursor = NULL,
  source = NULL,
  from_updated_date = NULL,
  until_updated_date = NULL,
  from_collected_date = NULL,
  until_collected_date = NULL,
  from_occurred_date = NULL,
  until_occurred_date = NULL,
  obj_id = NULL,
  obj_id_prefix = NULL,
  subj_id = NULL,
  subj_id_prefix = NULL,
  subj_id_domain = NULL,
  obj_id_domain = NULL,
  subj_url = NULL,
  obj_url = NULL,
  subj_url_domain = NULL,
  obj_url_domain = NULL,
  subj_alternative_id = NULL,
  obj_alternative_id = NULL,
  relation = NULL,
  facet = NULL,
  ...
)
}
\arguments{
\item{rows}{(character) the number of Events you want to retrieve per page.
The default, and recommended, value is 10,000, which allows you to retrieve
large numbers of Events quickly. There are typically between 10,000 and
100,000 Events collected per day. Default: 1000}

\item{cursor}{(character) allows you to iterate through a search result set.}

\item{source}{source ID}

\item{from_updated_date}{(character) from or until updated
date, as YYYY-MM-DD}

\item{until_updated_date}{(character) from or until updated
date, as YYYY-MM-DD}

\item{from_collected_date}{(character) from or until updated
date, as YYYY-MM-DD}

\item{until_collected_date}{(character) from or until updated
date, as YYYY-MM-DD}

\item{from_occurred_date}{(character) from or until occurred
date, as YYYY-MM-DD}

\item{until_occurred_date}{(character) from or until occurred
date, as YYYY-MM-DD}

\item{obj_id}{quoted URL or a DOI}

\item{obj_id_prefix}{DOI prefix like 10.5555}

\item{subj_id}{quoted URL or a DOI}

\item{subj_id_prefix}{DOI prefix like 10.5555}

\item{subj_id_domain}{domain of the subj_id e.g. en.wikipedia.org}

\item{obj_id_domain}{domain of the obj_url e.g. en.wikipedia.org}

\item{subj_url}{quoted full URL}

\item{obj_url}{quoted full URL}

\item{subj_url_domain}{domain of the optional subj.url, if present
e.g. en.wikipedia.org}

\item{obj_url_domain}{domain of the optional obj.url, if present
e.g. en.wikipedia.org}

\item{subj_alternative_id}{optional subj.alternative-id}

\item{obj_alternative_id}{optional obj.alternative-id}

\item{relation}{relation type ID}

\item{facet}{a facet value, can be just the facet name, or facet name plus
the limit (\code{*} or an integer)}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}.
Note that for now, when doing async you can't pass on curl options -
will try to add later.}
}
\description{
Query Crossref Deleted Events data
}
\section{facets}{


Remember that these totals don't refer to unique links necessarily,
so you should be cautious about using the numbers for anything
other than exploration.
\itemize{
\item source: source ID
\item relation-type: relation type ID
\item obj-id.prefix: DOI prefix like 10.5555, if Object is a DOI
\item subj-id.prefix: DOI prefix like 10.5555, if Subject is a DOI
\item subj-id.domain: Domain of the subj_id URL
\item obj-id.domain: Domain of the obj_id URL
\item subj.url.domain: Domain of the subj.url URL. This may or may not be
the same as the subj_id.
\item obj.url.domain: Domain of the obj.url URL. This may or may not be
the same as the obj_id.
}
}

\examples{
if (crul::ok("http://api.eventdata.crossref.org/v1/events?rows=0")) {
(res <- crev_deleted(rows = 3))
res$status
res$`message-type`
res$message$`total-results`
res$message$`items-per-page`
res$message$events
res$message$events$obj_id
}

\dontrun{
# filter with source
crev_deleted(rows = 3, source = "reddit")
crev_deleted(rows = 3, source = "twitter")

# on the first of March 2017s
crev_deleted(rows=3, from_collected_date = "2017-03-01", 
  until_collected_date = "2017-03-01")
  
# in the month of March 2017: occurred
crev_deleted(rows=3, from_occurred_date = "2017-03-01", 
  until_occurred_date = "2017-03-31")
  
# in the month of March 2017: collected
crev_deleted(rows=3, from_collected_date = "2017-03-01",
  until_collected_date = "2017-03-31")
  
# Up to ten Events for a DOI prefix
crev_deleted(rows = 3, obj_id_prefix = "10.1186")

# Up to ten events for a given DOI
crev_deleted(rows = 3, obj_id = "10.1186/s40536-017-0036-8")

# Use cursor
res <- crev_deleted(rows = 3)
crev_deleted(rows = 3, cursor = res$message$`next-cursor`)

# facet
crev_deleted(rows = 0, source = 'reddit', facet = "subj-id.domain:10")
crev_deleted(rows = 0, source = 'reddit', facet = "subj-id.domain:10")
crev_deleted(rows = 0, source = 'newsfeed', 
 subj_id_domain = "www.theguardian.com", facet = "obj-id.prefix:*")
}
}
