% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_proc_tools.R
\name{get_names}
\alias{get_names}
\title{Get Variable Names}
\usage{
get_names(dat, types = c("numeric", "integer", "double"),
  ex_cols = NULL, get_ex = FALSE)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{types}{The class or types of variables which names to get. Default: c('numeric', 'integer', 'double')}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{get_ex}{Logical ,if TRUE, return a list contains names of excluded variables.}
}
\value{
A list contains names of variables
}
\description{
\code{get_names} is  for getting names of particular classes of variables
}
\examples{
x_list = get_names(dat = UCICreditCard, types = c('factor', 'character'),
ex_cols = c("default.payment.next.month","ID$|_date$"), get_ex = FALSE)
x_list = get_names(dat = UCICreditCard,
ex_cols = c("default.payment.next.month","ID$|_date$"), get_ex = FALSE)
}
\seealso{
\code{\link{get_x_list}}
}
