% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_survfit_quantiles.R
\name{tbl_survfit_quantiles}
\alias{tbl_survfit_quantiles}
\alias{add_overall.tbl_survfit_quantiles}
\title{Survival Quantiles}
\usage{
tbl_survfit_quantiles(
  data,
  y = "survival::Surv(time = AVAL, event = 1 - CNSR, type = 'right', origin = 0)",
  by = NULL,
  header = "Time to event",
  estimate_fun = label_style_number(digits = 1, na = "NE"),
  method.args = list(conf.int = 0.95)
)

\method{add_overall}{tbl_survfit_quantiles}(
  x,
  last = FALSE,
  col_label = "All Participants  \\nN = {gtsummary::style_number(N)}",
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
A data frame}

\item{y}{(\code{string} or \code{expression})\cr
A string or expression with the survival outcome, e.g. \code{survival::Surv(time, status)}.
The default value is
\code{survival::Surv(time = AVAL, event = 1 - CNSR, type = "right", origin = 0)}.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}, which returns results for the unstratified model.}

\item{header}{(\code{string})\cr
String for the header of the survival quantile chunks.
Default is \code{"Time to event"}.}

\item{estimate_fun}{(\code{function})\cr
Function used to round and format the estimates in the table.
Default is \code{label_style_number(digits = 1)}.}

\item{method.args}{(named \code{list})\cr
Named list of arguments that will be passed to \code{survival::survfit()}.

Note that this list may contain non-standard evaluation components, and
must be handled similarly to tidyselect inputs by using
rlang's embrace operator \code{{{ . }}} or \code{!!enquo()} when programming with this
function.}

\item{x}{(\code{tbl_survfit_quantiles})\cr
A stratified 'tbl_survfit_quantiles' object.}

\item{last}{(scalar \code{logical})\cr
Logical indicator to display overall column last in table.
Default is \code{FALSE}, which will display overall column first.}

\item{col_label}{(\code{string})\cr
String indicating the column label. Default is \code{"**Overall**  \nN = {style_number(N)}"}}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
a gtsummary table
}
\description{
Create a gtsummary table with Kaplan-Meier estimated survival quantiles.
If you must further customize the way these results are presented,
see the Details section below for the full details.
}
\section{ARD-first}{


This function is a helper for creating a common summary.
But if you need to modify the appearance of this table, you may need to build
it from ARDs.

Here's the general outline for creating this table directly from ARDs.
\enumerate{
\item Create an ARD of survival quantiles using \code{cardx::ard_survival_survfit()}.
\item Construct an ARD of the minimum and maximum survival times using \code{cards::ard_summary()}.
\item Combine the ARDs and build summary table with \code{gtsummary::tbl_ard_summary()}.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# get the survival quantiles with 95\% CI
ard_surv_quantiles <-
  cardx::ard_survival_survfit(
    x = cards::ADTTE,
    y = survival::Surv(time = AVAL, event = 1 - CNSR, type = 'right', origin = 0),
    variables = "TRTA",
    probs = c(0.25, 0.50, 0.75)
  ) |>
  # modify the shape of the ARD to look like a
  # 'continuous' result to feed into `tbl_ard_summary()`
  dplyr::mutate(
    stat_name = paste0(.data$stat_name, 100 * unlist(.data$variable_level)),
    variable_level = list(NULL)
  )

# get the min/max followup time
ard_surv_min_max <-
  cards::ard_summary(
    data = cards::ADTTE,
    variables = AVAL,
    by = "TRTA",
    statistic = everything() ~ cards::continuous_summary_fns(c("min", "max"))
  )

# stack the ARDs and pass them to `tbl_ard_summary()`
cards::bind_ard(
  ard_surv_quantiles,
  ard_surv_min_max
) |>
  tbl_ard_summary(
    by = "TRTA",
    type = list(prob = "continuous2", AVAL = "continuous"),
    statistic = list(
      prob = c("\{estimate50\}", "(\{conf.low50\}, \{conf.high50\})", "\{estimate25\}, \{estimate75\}"),
      AVAL = "\{min\} to \{max\}"
    ),
    label = list(
      prob = "Time to event",
      AVAL = "Range"
    )
  ) |>
  # directly modify the labels in the table to match spec
  modify_table_body(
    ~ .x |>
      dplyr::mutate(
        label = dplyr::case_when(
          .data$label == "Survival Probability" ~ "Median",
          .data$label == "(CI Lower Bound, CI Upper Bound)" ~ "95\% CI",
          .data$label == "Survival Probability, Survival Probability" ~ "25\% and 75\%-ile",
          .default = .data$label
        )
      )
  ) |>
  # update indentation to match spec
  modify_indent(columns = "label", rows = label == "95\% CI", indent = 8L) |>
  modify_indent(columns = "label", rows = .data$label == "Range", indent = 4L) |>
  # remove default footnotes
  remove_footnote_header(columns = all_stat_cols())
}\if{html}{\out{</div>}}
}

\examples{
# Example 1 ----------------------------------
tbl_survfit_quantiles(
  data = cards::ADTTE,
  by = "TRTA",
  estimate_fun = label_style_number(digits = 1, na = "NE")
) |>
  add_overall(last = TRUE, col_label = "**All Participants**  \nN = {n}")

# Example 2: unstratified analysis -----------
tbl_survfit_quantiles(data = cards::ADTTE)
}
