% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Spol}
\alias{Spol}
\title{Survival function of Zipf-polylog distribution}
\usage{
Spol(x, alpha, theta, x_max = 100000L)
}
\arguments{
\item{x}{Vector of positive integers}

\item{alpha}{Real number greater than 1}

\item{theta}{Real number in (0, 1]}

\item{x_max}{Scalar (default 100000), positive integer limit for computing the normalising constant}
}
\value{
A numeric vector of the same length as x
}
\description{
\code{Spol} returns the survival function at x for the Zipf-polylog distribution with parameters (alpha, theta). The distribution is reduced to the discrete power law when theta = 1.
}
\examples{
Spol(c(1,2,3,4,5), 1.2, 0.5)
}
\seealso{
\code{\link{dpol}} for the corresponding probability mass function, \code{\link{Smix2}} and \code{\link{Smix3}} for the survival functions of the 2-component and 3-component discrete extreme value mixture distributions, respectively.
}
