% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dep.R
\name{get_dep_df}
\alias{get_dep_df}
\alias{get_dep_all}
\alias{get_dep}
\title{Multiple types of dependencies}
\usage{
get_dep_df(name, type, scrape = TRUE)

get_dep_all(name, type, scrape = TRUE)

get_dep(name, type, scrape = TRUE)
}
\arguments{
\item{name}{String, name of the package}

\item{type}{A character vector that contains one or more of the following dependency words: "Depends", "Imports", "LinkingTo", "Suggests", "Enhances", "Reverse depends", "Reverse imports", "Reverse linking to", "Reverse suggests", "Reverse enhances", up to letter case and space replaced by underscore. Alternatively, if 'type = "all"', all ten dependencies will be obtained.}

\item{scrape}{Boolean. If 'TRUE' (default), the page of the package will be scraped. If 'FALSE', tools::CRAN_package_db() will be used. Whether the argument equals 'TRUE' or 'FALSE' should not affect the output, but only the time taken. Usually, the former is faster than the latter for a single package.}
}
\value{
A data frame of dependencies
}
\description{
\code{get_dep} returns a data frame of multiple types of dependencies of a package
}
\examples{
get_dep("dplyr", c("Imports", "Depends"))
get_dep("MASS", c("Suggests", "Depends", "Imports"), TRUE) # FALSE will give same result
}
\seealso{
\code{\link{get_dep_all_packages}} for the dependencies of all CRAN packages, and \code{\link{get_graph_all_packages}} for obtaining directly a network of dependencies as an igraph object
}
