% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switch_axis.R
\name{switch_axis_position}
\alias{switch_axis_position}
\title{Switches the axis position of the x or y axis in a plot.}
\usage{
switch_axis_position(plot, axis = c("y", "x", "xy"), keep = c("none", "x",
  "y", "xy", "yx"))
}
\arguments{
\item{plot}{The plot on which to perform the operation.}

\item{axis}{String indicating which axis to switch. Valid options are"x", "y", and "xy".
The default is "y".}

\item{keep}{String indicating which if any original axis to keep. Valid options
are"x", "y", "xy", and "none". The default is "none".}
}
\value{
A gtable object (not ggplot object!) on which the axes have been switched.
}
\description{
Switches the axis position of the x or y axis in a plot.
}
\examples{
p <- ggplot(mtcars, aes(mpg, disp)) + geom_line(colour = "blue")
ggdraw(switch_axis_position(p, axis = 'y'))
ggdraw(switch_axis_position(p, axis = 'x'))
ggdraw(switch_axis_position(p + theme_bw(), axis = 'xy', keep = 'x'))
}

