% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19sf_hospital}
\alias{covid19sf_hospital}
\title{San Francisco COVID-19 Hospital Capacity}
\format{
An object class data.frame with 5 variables
\describe{
  \item{hospital}{The hospital name, currently a single categorical variable, c("All SF Acute Hospitals")}
  \item{date}{Date which the data was recorded in YYYY-MM-DD format}
  \item{bed_type}{The bed type, c("Intensive Care Surge", "Acute Care", "Acute Care Surge", "Intensive Care") }
  \item{status}{The bed category status, c("Available", "COVID-19 (Confirmed & Suspected)", "Other Patients")}
  \item{count}{The bed count}
  }
}
\source{
San Francisco, Department of Public Health - Population Health Division through San Francisco Opne Data protal \href{https://datasf.org/opendata/}{website}.
}
\usage{
covid19sf_hospital
}
\description{
Data on daily hospital bed use and available capacity at San Francisco
acute care hospitals from April 2020 onward.
Long Term Care facilities (like Laguna Honda and Kentfield) are not included
in this data as acute care patients cannot be admitted to these facilities.
More information about the data available \href{https://data.sfgov.org/COVID-19/COVID-19-Hospital-Capacity/rh24-ebzg}{here}
}
\details{
The dataset contains a summary of San Francisco hospital bed status
}
\examples{
data(covid19sf_hospital)

head(covid19sf_hospital)
}
\keyword{COVID19}
\keyword{bed}
\keyword{datasets}
\keyword{hospital}
\keyword{summary}
