% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19sf_geo}
\alias{covid19sf_geo}
\title{San Francisco COVID-19 Cases and Deaths Summarized by Geography}
\format{
An object class sf and data.frame with 8 variables.
\describe{
  \item{area_type}{Area type, c("ZCTA", "Analysis Neighborhood", "Census Tract", "Citywide")}
  \item{id}{area id}
  \item{count}{The count of cases in the area}
  \item{rate}{The rate of cases in the area, calculated as (count/acs_population) * 10000 which is a rate per 10,000 residents}
  \item{deaths}{The number of cases in the area }
  \item{acs_population}{The population from the latest 5-year estimates from the American Community Survey (2014-2018))}
  \item{last_updated}{Last update of the data in POSIXc format)}
  \item{geometry}{The area polygon data)}
  }
}
\source{
San Francisco, Department of Public Health - Population Health Division through San Francisco Opne Data protal \href{https://datasf.org/opendata/}{website}.
}
\usage{
covid19sf_geo
}
\description{
Medical provider confirmed COVID-19 cases and confirmed COVID-19 related deaths
in San Francisco, CA aggregated by several different geographic areas and normalized by
2018 American Community Survey (ACS) 5-year estimates for population data to calculate rate per 10,000 residents.
More information about the data available \href{https://data.sfgov.org/COVID-19/COVID-19-Cases-and-Deaths-Summarized-by-Geography/tpyr-dvnc}{here}
}
\details{
The dataset contains a summary of covid19 cases in San Francisco by geographic area
}
\examples{
data(covid19sf_geo)

head(covid19sf_geo)

library(sf)
# Ploting SF Covid19 counts using base plot function
# Plotting by zip code
plot(covid19sf_geo[which(covid19sf_geo$area_type == "ZCTA"),
                   c("count", "geometry")],
      main = "Covid19 Cases by ZIP Code")
# Plotting by neighborhood
plot(covid19sf_geo[which(covid19sf_geo$area_type ==
                         "Analysis Neighborhood"),
                   c("count", "geometry")],
     main = "Covid19 Cases by Neighborhood")
#Plotting by census tract
plot(covid19sf_geo[which(covid19sf_geo$area_type == "Census Tract"),
                   c("count", "geometry")],
     main = "Covid19 Cases by Census Tract")
plot(covid19sf_geo[which(covid19sf_geo$area_type == "Census Tract"),
                   c("rate", "geometry")],
     main = "Covid19 Cases Rate per 10,000 by Census Tract")
}
\keyword{COVID19}
\keyword{datasets}
\keyword{geo}
\keyword{map}
\keyword{summary}
