% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_geo.R
\docType{data}
\name{geocities}
\alias{geocities}
\title{City-level georeferenced data}
\format{
A data frame with 5570 rows and 16 variables:
\itemize{
  \item region: regions' names
  \item state: states' names.
  \item city: cities' names.
  \item DHI: development human index.
  \item EDHI: educational development human index.
  \item LDHI: longevity development human index.
  \item IDHI: income development human index.
  \item pop: estimated population in 2019.
  \item region_code: numerical code attributed to regions
  \item state_code: numerical code attributed to states
  \item mesoregion_code: numerical code attributed to mesoregions
  \item microregion_code: numerical code attributed to microregions
  \item city_code: numerical code attributed to cities
  \item geometry: georeferenced data needed to plot maps.
  \item area: area (in Km^2)
  \item pop_dens: demographic density.
}
}
\source{
\itemize{
    \item Shapefiles for Brazilian maps: \url{https://www.ibge.gov.br/geociencias/downloads-geociencias.html}
    \item Brazilian DHI data: \url{https://github.com/ipea/IpeaGeo}
  }
}
\description{
Data set obtained from the Instituto Brasileiro de Geografia e Estatística (IBGE) with data on the Brazilian population and geographical information on city level.
}
\details{
The development human index (DHI) variables are available at city level, and their average are computed for state and region levels.
}
\author{
Fabio N. Demarqui \email{fndemarqui@est.ufmg.br}
}
\keyword{datasets}
