% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_data.R
\name{flood_analysis}
\alias{flood_analysis}
\title{Compute flood statistics}
\usage{
flood_analysis(flow_data, peaks, gages, county_cd, q2_val = data.frame(site_no
  = "", q2 = NA, stringsAsFactors = FALSE), threshold, weight = "Q2")
}
\arguments{
\item{flow_data}{A data frame with discharge data for each USGS gage found
for the specified data range. Output from \code{get_flow_data} function.}

\item{peaks}{A data frame of USGS gage IDs and flood values obtained from
either the \code{find_Q2} or \code{find_NWS} function.}

\item{gages}{A data frame of all USGS gages and metadata obtained from the
\code{get_gages} function. This input is used to add lat/long and county
codes to the summarized output.}

\item{county_cd}{Character vector with the county FIPS code(s)}

\item{q2_val}{A data frame with values of the median annual flood to be used
to compare relative sizes of streams at gage locations}

\item{threshold}{Character string of the flood threshold to be used in the
analysis (either "Q2" or "NWS"). Used to determine which type of summary
statistics to compute.}

\item{weight}{Character string of variable to be used to scale by river size
for weighted averages and scaling point sizes on maps. Options are median
annual flood ("Q2") or drainage area ("DA"). Defaults to "Q2".}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description\cr
site_no \tab character \tab USGS gage ID\cr
county_cd \tab character \tab FIPS code of gage county location\cr
lat \tab numeric \tab Gage latitude\cr
long \tab numeric \tab Gage longitude\cr
avg_peak \tab numeric \tab Mean flood ratio for date range (discharge/flood threshold)\cr
flood_dur \tab numeric \tab Number of days in date range discharge above flood threshold\cr
max_peak \tab numeric \tab Maximum value of flood ratio for date range (discharge/flood threshold)\cr
num_missing \tab numeric \tab Number of days with missing discharge data from input date range\cr
Q2 \tab numeric \tab Median annual discharge (cubic feet per second)\cr
DA \tab numeric \tab Drainage area of the gage (square miles)\cr
size \tab numeric \tab Relative river size, logarithm of either Q2 or DA
     depending on user specified \code{weight}\cr
state \tab character \tab State name\cr
county \tab character \tab County name\cr
flood \tab character \tab Flood magnitude category based on peak
}
}
\description{
Takes flow data and computes flood statistics based on selected flood
threshold.
}
\examples{
\dontrun{
va_counties <- get_county_cd("Virginia")
va_gages <- get_gages(va_counties, start_date = "2015-01-01",
                      end_date = "2015-12-31")
va_flow_data <- get_flow_data(va_gages, start_date = "2015-01-01",
                      end_date = "2015-12-31")
va_peaks <- find_q2(va_gages$site_no)
va_stats <- flood_analysis(flow_data = va_flow_data, peaks = va_peaks,
                       gages = va_gages, county_cd = va_counties, threshold = "Q2")
}
}
