% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_results.R
\name{time_series_plot}
\alias{time_series_plot}
\title{Function plots time series data by county}
\usage{
time_series_plot(county_series, category = "moderate", start_date = NULL,
  end_date = NULL)
}
\arguments{
\item{county_series}{Data frame of flood time series results by county,
output of \code{time_series_flood} function.}

\item{category}{Character string of the flood magnitude category to be used
for mapping (one of "minor", "moderate", "major", or "extreme").}

\item{start_date}{Character string of start date for x-axis of plots. If not
specified, defaults to the earliest observed flood in the data.}

\item{end_date}{Character string of end date for x-axis of plots. If not
specified, defaults to the latest observed flood in the data.}
}
\value{
Four time series bar charts per county displaying the number of
gages with flooding, maximum flood ratio, average flood ratio, and the
percent of gages above a specified flood threshold.
}
\description{
Displays four time series bar charts per county displaying the number of
gages with flooding, maximum flood ratio, average flood ratio, and the
percent of gages above a specified flood threshold.
}
\examples{
\dontrun{
#Use Q2 as flood threshold
va_time_series <- time_series_flood(state = "Virginia", start_date = "2015-01-01",
                      end_date = "2015-12-31", threshold = "Q2")

#Map results
time_series_plot(va_time_series[[2]])
}
}
