% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WHC.R
\name{WHC}
\alias{WHC}
\title{Weighted Hochberg method}
\usage{
WHC(p, w, alpha = 0.05)
}
\arguments{
\item{p}{A numeric vector. A length \eqn{m} P-value vector from multiple tests.}

\item{w}{A numeric vector. Any non-negative real numbers to denote the
importance of the endpoints. Length must be equal to \eqn{m}. A single value,
e.g. \code{w = 1}, represents equal weight. \code{WHC} can scale the weight vector as if
the sum of weight is not 1.}

\item{alpha}{A real number. \eqn{1-\alpha} is the confidence level, \code{alpha} must between (0, 1).}
}
\value{
A table contains p-values, weights, adjusted critical values, significance
}
\description{
\code{WHC} performs the weighted Hochberg method proposed by Tamhane and Liu (2008).
}
\examples{
m <- 5
WHC(
  p = runif(m),
  w = runif(m)
)
}
\references{
Tamhane, A. C., & Liu, L. (2008). On weighted Hochberg procedures. Biometrika, 95(2), 279-294.
}
