% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otu_to_taxonomy.R
\name{otu_to_taxonomy}
\alias{otu_to_taxonomy}
\title{Transform OTUs to their taxonomic label}
\usage{
otu_to_taxonomy(OTU, data, level = NULL)
}
\arguments{
\item{OTU}{String vector. Names of OTU labels in \code{data}}

\item{data}{\code{phyloseq} object with a taxonomy table}

\item{level}{(Optional). Character vector. Desired taxonomic levels for output.}
}
\value{
String vector. Names of taxonomic labels matching labels of \code{OTU}.
}
\description{
Transform OTUs to their taxonomic label
}
\examples{
data(soil_phylum_small)
da_analysis <- differentialTest(formula = ~ DayAmdmt,
                                phi.formula = ~ DayAmdmt,
                                formula_null = ~ 1,
                                phi.formula_null = ~ DayAmdmt,
                                test = "Wald", boot = FALSE,
                                data = soil_phylum_small,
                                fdr_cutoff = 0.05)
otu_to_taxonomy(OTU = da_analysis$significant_taxa, data = soil_phylum_small,
 level = "Phylum")

}
