% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{qi_slimmer}
\alias{qi_slimmer}
\title{Find maximum, minimum, and median values for each scenario found using
\code{\link{qi_builder}}}
\usage{
qi_slimmer(df, scenario_var = "scenario_", qi_var = "qi_")
}
\arguments{
\item{df}{a data frame of simulated quantities of interest created by
\code{\link{qi_builder}}.}

\item{scenario_var}{character string of the variable name marking the
scenarios.}

\item{qi_var}{character string of the name of the variable with the
simulated quantity of interest values.}
}
\value{
A data frame with the fitted values and the minimum (\code{qi_min}),
median (\code{qi_median}), and maximum (\code{qi_max}) values from the
central interval specified with \code{ci} in \code{\link{qi_builder}}.
}
\description{
Find maximum, minimum, and median values for each scenario found using
\code{\link{qi_builder}}
}
\details{
This funciton slims down a simulation data set to some of its key
features (minimun, median, and maximum value for each fitted scenario) so that
it takes up less memory and can be easily plotted.

The function is incorporated into \code{\link{qi_builder}} and can be run
using \code{slim = TRUE}.
}
\examples{
library(car)

# Normal linear model
m1 <- lm(prestige ~ education + type, data = Prestige)

# Simulate coefficients
m1_sims <- b_sim(m1)

# Create fitted values
fitted_df <- expand.grid(education = 6:16, typewc = 1)

# Find predicted outcomes (95\% central interval, by default)
linear_qi <- qi_builder(b_sims = m1_sims, newdata = fitted_df, slim = FALSE)

# Slim data set
linear_slim <- qi_slimmer(linear_qi)

}

