% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.R
\name{jackknife}
\alias{jackknife}
\title{Jackknife Estimation}
\usage{
jackknife(x, f, y = NULL, ...)
}
\arguments{
\item{x}{data vector}

\item{f}{estimator function \code{f(x,...)} or \code{f(x,y,...)}}

\item{y}{optional data vector if \code{f} is a function of two vectors, such as the correlation coefficient \code{cor(x,y)}.}

\item{...}{optional arguments to be passed to \code{f}.}
}
\value{
Returns a list with the following components:
\item{value}{Default value of the estimator \code{f}.}
\item{bias}{Jackknife bias estimate of \code{f}.}
\item{unbiased}{Bias-corrected value of \code{f}.}
\item{sd}{Jackknife standard error of \code{f}.}
}
\description{
Computes the "leave-one-out" Jackknife bias and standard error of an estimator \code{f(x)} of a data-vector \code{x}, or an estimator \code{f(x,y)} of vectors \code{x} and \code{y}. See Efron and Tibshirani (1993) for details
}
\author{
Danail Obreschkow
}
