% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landyszalay.R
\name{landyszalay}
\alias{landyszalay}
\title{Two-point correlation estimation}
\usage{
landyszalay(D, R, dr = 0.1, cpp = TRUE)
}
\arguments{
\item{D}{n-element vector or n-by-d matrix of d-dimensional positions of the data points}

\item{R}{m-element vector or m-by-d matrix of d-dimensional positions of the random comparison points}

\item{dr}{bin size for the evaluation of the two-point correlation function}

\item{cpp}{logical flag; if set to TRUE (default) a fast implementation in C++ is used to count the point-pairs in distance bins, otherwise the counting is performed less efficiently in R.}
}
\value{
Returns a data frame with the two-point statistics of the data points:
\item{r}{vector with the mid-points of the distance bins for which the two-point correlation function has been evaluated.}
\item{xi}{values of the two-point correlation function at the distances r.}
\item{err}{Poisson errors of xi.}
}
\description{
Evaluates the Landy-Szalay (1993) estimator of the two-point correlation function of a point set D given a random comparison set R. The two point sets D and R can be made of different numbers of points, as the pair-counts are automatically normalized according to the number of points. In fact, it is often preferable to make the R set larger to reduce the R-related shot noise in the two-point estimator.
}
\seealso{
\code{\link{paircount}}
}
\author{
Danail Obreschkow
}
