% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyrich.R
\name{svyrich}
\alias{svyrich}
\alias{svyrich.survey.design}
\alias{svyrich.svyrep.design}
\alias{svyrich.DBIsvydesign}
\title{Richness measures}
\usage{
svyrich(formula, design, ...)

\method{svyrich}{survey.design}(
  formula,
  design,
  type_measure,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 1.5,
  quantiles = 0.5,
  thresh = FALSE,
  na.rm = FALSE,
  deff = FALSE,
  linearized = FALSE,
  ...
)

\method{svyrich}{svyrep.design}(
  formula,
  design,
  type_measure,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 1.5,
  quantiles = 0.5,
  thresh = FALSE,
  na.rm = FALSE,
  deff = FALSE,
  linearized = FALSE,
  return.replicates = FALSE,
  ...
)

\method{svyrich}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{passed to \code{svyarpt}}

\item{type_measure}{A string "Cha", "FGTT1" or "FGTT2" defining the richness measure.}

\item{g}{Richness preference parameter.}

\item{type_thresh}{type of richness threshold. If "abs" the threshold is fixed and given the value of abs_thresh; if "relq" it is given by \code{percent} times the quantile; if "relm" it is \code{percent} times the mean.}

\item{abs_thresh}{richness threshold value if type_thresh is "abs"}

\item{percent}{the multiple of the quantile or mean used in the richness threshold definition. Defaults to \code{percent = 1.5}; i.e., 1.5 times the quantile or mean.}

\item{quantiles}{the quantile used used in the richness threshold definition. Defaults to \code{quantiles = .5}, the median.}

\item{thresh}{return the richness threshold value}

\item{na.rm}{Should cases with missing values be dropped?}

\item{deff}{Return the design effect (see \code{survey::svymean})}

\item{linearized}{Should a matrix of linearized variables be returned}

\item{return.replicates}{Return the replicate estimates?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate Peichl, Schaefer and Scheicher (2010) richness measures.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design

des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

# concave Chakravarty richness measure
# higher g= parameters tend toward headcount ratio, richness threshold fixed
svyrich(~eqincome, des_eusilc, type_measure = "Cha" , g=3,  abs_thresh=30000)
# g=1 parameter computes the richness gap index, richness threshold fixed
svyrich(~eqincome, des_eusilc, type_measure = "Cha" , g=1,  abs_thresh=30000)
# higher g= parameters tend toward headcount ratio, richness threshold equal to the median
svyrich(~eqincome, des_eusilc, type_measure = "Cha" , g=3, type_thresh= "relq" )
# g=1 parameter computes the richness gap index, richness threshold equal to the median
svyrich(~eqincome, des_eusilc, type_measure = "Cha" , g=1, type_thresh= "relq" )
# higher g= parameters tend toward headcount ratio, richness threshold equal to the mean
svyrich(~eqincome, des_eusilc, type_measure = "Cha" , g=3, type_thresh= "relm" )
# g=1 parameter computes the richness gap index, richness threshold equal to the mean
svyrich(~eqincome, des_eusilc, type_measure = "Cha" , g=1, type_thresh= "relm" )

#  using svrep.design:
# higher g= parameters tend toward headcount ratio, richness threshold fixed
svyrich(~eqincome, des_eusilc_rep, type_measure = "Cha" , g=3, abs_thresh=30000 )
# g=1 parameter computes the richness gap index, richness threshold fixed
svyrich(~eqincome, des_eusilc_rep, type_measure = "Cha" , g=1, abs_thresh=30000 )
# higher g= parameters tend toward headcount ratio, richness threshold equal to the median
svyrich(~eqincome, des_eusilc_rep, type_measure = "Cha" , g=3, type_thresh= "relq" )
# g=1 parameter computes the richness gap index, richness threshold equal to the median
svyrich(~eqincome, des_eusilc_rep, type_measure = "Cha" , g=1, type_thresh= "relq" )
# higher g= parameters tend toward headcount ratio, richness threshold equal to the mean
svyrich(~eqincome, des_eusilc_rep, type_measure = "Cha" , g=3, type_thresh= "relm" )
# g=1 parameter computes the richness gap index, richness threshold equal to the mean
svyrich(~eqincome, des_eusilc_rep, type_measure = "Cha" , g=1, type_thresh= "relm" )

\dontrun{

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)


dbd_eusilc <- convey_prep( dbd_eusilc )

# higher g= parameters tend toward headcount ratio, richness threshold fixed
svyrich(~eqincome, dbd_eusilc, type_measure = "Cha" , g=3, abs_thresh=30000 )
# g=1 parameter computes the richness gap index, richness threshold fixed
svyrich(~eqincome, dbd_eusilc, type_measure = "Cha" , g=1, abs_thresh=30000 )
# higher g= parameters tend toward headcount ratio, richness threshold equal to the median
svyrich(~eqincome, dbd_eusilc, type_measure = "Cha" , g=3, type_thresh= "relq" )
# g=1 parameter computes the richness gap index, richness threshold equal to the median
svyrich(~eqincome, dbd_eusilc, type_measure = "Cha" , g=1, type_thresh= "relq" )
# higher g= parameters tend toward headcount ratio, richness threshold equal to the mean
svyrich(~eqincome, dbd_eusilc, type_measure = "Cha" , g=3, type_thresh= "relm" )
# g=1 parameter computes the richness gap index, richness threshold equal to the mean
svyrich(~eqincome, dbd_eusilc, type_measure = "Cha" , g=1, type_thresh= "relm" )

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Michal Brzezinski (2014). Statistical Inference for Richness Measures. \emph{Applied Economics},
Vol. 46, No. 14, pp. 1599-1608, DOI \doi{10.1080/00036846.2014.880106}.

Andreas Peichl, Thilo Schaefer, and Christoph Scheicher (2010). Measuring richness and poverty: A micro data
application to Europe and Germany. \emph{Review of Income and Wealth}, Vol. 56, No.3, pp. 597-619.

Guillaume Osier (2009). Variance estimation for complex indicators of poverty and inequality.
\emph{Journal of the European Survey Research Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{https://ojs.ub.uni-konstanz.de/srm/article/view/369}.
}
\seealso{
\code{\link{svyfgt}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
