% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyzengacurve.R
\name{svyzengacurve}
\alias{svyzengacurve}
\alias{svyzengacurve.survey.design}
\alias{svyzengacurve.svyrep.design}
\alias{svyzengacurve.DBIsvydesign}
\title{Zenga inequality curve (EXPERIMENTAL)}
\usage{
svyzengacurve(formula, design, ...)

\method{svyzengacurve}{survey.design}(
  formula,
  design,
  quantiles = seq(0, 1, 0.1),
  empirical = FALSE,
  plot = TRUE,
  add = FALSE,
  curve.col = "red",
  ci = TRUE,
  alpha = 0.05,
  na.rm = FALSE,
  ...
)

\method{svyzengacurve}{svyrep.design}(
  formula,
  design,
  quantiles = seq(0, 1, 0.1),
  empirical = FALSE,
  plot = TRUE,
  add = FALSE,
  curve.col = "red",
  ci = TRUE,
  alpha = 0.05,
  na.rm = FALSE,
  ...
)

\method{svyzengacurve}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{additional arguments passed to \code{plot} methods}

\item{quantiles}{a sequence of probabilities that defines the quantiles sum to be calculated}

\item{empirical}{Should an empirical Zenga curve be estimated as well? Defaults to \code{FALSE}.}

\item{plot}{Should the Zenga curve be plotted? Defaults to \code{TRUE}.}

\item{add}{Should a new curve be plotted on the current graph?}

\item{curve.col}{a string defining the color of the curve.}

\item{ci}{Should the confidence interval be plotted? Defaults to \code{TRUE}.}

\item{alpha}{a number that especifies de confidence level for the graph.}

\item{na.rm}{Should cases with missing values be dropped? Defaults to \code{FALSE}.}
}
\value{
Object of class "\code{svyquantile}", which are vectors with a "\code{quantiles}" attribute giving the complement of the ratio between the lower and upper means,
and a "\code{SE}" attribute giving the standard errors of the estimates.
}
\description{
Estimate the Zenga curve, an inequality graph
}
\details{
WARNING: this is an experimental version. Use with caution.

You must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.

Notice that the 'empirical' curve is observation-based and is based on the Lorenz curve formula actually used to calculate the Gini index.
On the other hand, the quantile-based curve is used to estimate the complement of the ratio between the means, SEs and confidence intervals.

This way, as the number of quantiles of the quantile-based function increases, the quantile-based curve approaches the observation-based curve.
}
\note{
This function is experimental and is subject to changes in later versions.
}
\examples{

library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )
svyzengacurve( ~eqincome , des_eusilc,  alpha = .01 )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

svyzengacurve( ~eqincome , des_eusilc_rep,  alpha = .01 )

\dontrun{

# linearized design using a variable with missings
svyzengacurve( ~py010n , des_eusilc, alpha = .01 )
svyzengacurve( ~py010n , des_eusilc, alpha = .01, na.rm = TRUE )
# demonstration of `curve.col=` and `add=` parameters
svyzengacurve( ~eqincome , des_eusilc,  alpha = .05 , add = TRUE , curve.col = 'green' )
# replicate-weighted design using a variable with missings
svyzengacurve( ~py010n , des_eusilc_rep, alpha = .01 )
svyzengacurve( ~py010n , des_eusilc_rep, alpha = .01, na.rm = TRUE )



# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

svyzengacurve( ~eqincome , dbd_eusilc, alpha = .01 )

# highlighting the difference between the quantile-based curve and the empirical version:
svyzengacurve( ~eqincome , dbd_eusilc, seq(0,1,.1), empirical = TRUE, curve.col = "green" )
svyzengacurve( ~eqincome , dbd_eusilc, seq(0,1,.1), alpha = .01, add = TRUE )
legend( "bottomleft", c("Quantile-based", "Empirical"), lwd = c(1,1), col = c("red", "green"))

# as the number of quantiles increases, the difference between the curves gets smaller
svyzengacurve( ~eqincome , dbd_eusilc, seq(0,1,.01), empirical = TRUE, curve.col = "green" )
svyzengacurve( ~eqincome , dbd_eusilc, seq(0,1,.01), alpha = .01, add = TRUE )
legend( "bottomleft", c("Quantile-based", "Empirical"), lwd = c(1,1), col = c("red", "green"))

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Marcella Polisicchio and Francesco Porro (2011). A Comparison Between Lorenz L(P) Curve
and Zenga I(P) Curve. Statistica Applicata, v. 21, n. 3-4, 289-301.

Matti Langel (2012). \emph{Measuring inequality in finite population sampling}. PhD thesis. URL \url{http://doc.rero.ch/record/29204}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X19990024882}.
}
\seealso{
\code{\link{svyquantile}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
