% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{DISTRIBUTION_factory}
\alias{DISTRIBUTION_factory}
\title{A factory of \code{\link{DISTRIBUTION}} classes}
\usage{
DISTRIBUTION_factory(distname, rfunction, ovalfunc)
}
\arguments{
\item{distname}{name of the distribution. By convention they are upper case}

\item{rfunction}{a function to generate random numbers from the distribution}

\item{ovalfunc}{a function that calculate the oval value, should used only
the same arguments that the \code{rfunction}}
}
\value{
A function that is able to create \code{\link{DISTRIBUTION}} objects.
}
\description{
Generate a function that creates \code{\link{DISTRIBUTION}} objects
}
\note{
The function return a new function, that have as arguments the formals
of the \code{rfunction} plus a new argument \code{dimnames} for the dimension
names. If The distribution is unidimensional, the default value 
\code{ dimnames = "rvar"} will  works well, but if not, the \code{dimnames} 
argument should be specified when the generated function is used as in 
the example for the \code{new_MyDIRICHLET}
}
\examples{
new_MYDISTR <- DISTRIBUTION_factory("MYDISTR", rnorm, function(){mean})
d1 <- new_MYDISTR(0,1)
summary(d1)
require(extraDistr)
new_MyDIRICHLET <- DISTRIBUTION_factory('rdirichlet',
                       rdirichlet,
                       function() {
                         salpha = sum(alpha)
                         alpha / salpha
                       })
d2 <- new_MyDIRICHLET(c(10, 20, 70), dimnames = c("A", "B", "C"))
summary(d2)
}
\author{
John J. Aponte
}
\keyword{DISTRIBUTION}
