% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_chi_squared_test_CC_2x2.R
\name{Pearson_chi_squared_test_CC_2x2}
\alias{Pearson_chi_squared_test_CC_2x2}
\title{The Pearson chi-squared test for association in 2x2 tables}
\usage{
Pearson_chi_squared_test_CC_2x2(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A data frame containing the two-sided p-value, the statistic and the degrees of freedom
}
\description{
The Pearson chi-squared test for association in 2x2 tables

with continuity correction

Described in Chapter 4 "The 2x2 Table"
}
\examples{
# Example: A lady tasting a cup of tea
n <- rbind(c(3, 1), c(1, 3))
Pearson_chi_squared_test_CC_2x2(n)

# Example: Perondi et al. (2004)
n <- rbind(c(7, 27), c(1, 33))
Pearson_chi_squared_test_CC_2x2(n)

# Example: Lampasona et al. (2013)
n <- rbind(c(9, 4), c(4, 10))
Pearson_chi_squared_test_CC_2x2(n)

# Example: Ritland et al. (2007)
n <- rbind(c(0, 16), c(15, 57))
Pearson_chi_squared_test_CC_2x2(n)

}
