% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_utility.R
\name{sim_post}
\alias{sim_post}
\title{Binomial Posterior Simulator}
\usage{
sim_post(x, n, alpha = 1, beta = 1, ndraws = 5000)
}
\arguments{
\item{x}{Vector of the number of successes per arm.}

\item{n}{Vector of the number of trials per arm.}

\item{alpha}{Shape parameter alpha for the prior beta distribution.}

\item{beta}{Shape parameter beta for the prior beta distribution.}

\item{ndraws}{Number of random draws from the posterior.}
}
\value{
Matrix of bayesian probabilities for each arm being the best binomial bandit
}
\description{
Simulates the posterior distribution of
the Bayesian probabilities for each arm being the
best binomial bandit.
}
\examples{

x <- c(10,20,30,50)
n <- c(100,102,120,130)
sp <- sim_post(x,n)

}
\author{
Thomas Lotze and Markus Loecher
}
