% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy.R
\name{Policy}
\alias{Policy}
\alias{get_action}
\alias{set_reward}
\alias{set_parameters}
\alias{initialize_theta}
\alias{policy}
\alias{theta}
\title{Policy: Superclass}
\description{
Parent or superclass of all \code{\{contextual\}} \code{Policy} subclasses.
}
\details{
On every \emph{t} = {1, \ldots, T}, a policy receives \code{d} dimensional feature vector or
\code{d x k} dimensional matrix
\code{context$X}*, the current number of \code{\link{Bandit}} arms in \code{context$k}, and the current
number of contextual features in \code{context$d}.

To make sure a policy supports both contextual feature vectors and matrices in \code{context$X}, it is
suggested any contextual policy makes use of \pkg{contextual}'s \code{get_arm_context(context, arm)}
utility function to obtain the current context for a particular arm, and \code{get_full_context(context)}
where a policy makes direct use of a \code{d x k} context matrix.

It has to compute which of the \code{k}
\code{\link{Bandit}} arms to pull by taking into account this contextual information plus the policy's
current parameter values stored in the named list \code{theta}. On selecting an arm, the policy then
returns its index as \code{action$choice}.

\figure{3bpolicy.jpeg}{contextual diagram: get context}

On pulling a \code{\link{Bandit}} arm the policy receives a \code{\link{Bandit}} reward through
\code{reward$reward}. In combination with the current \code{context$X}* and \code{action$choice},
this reward can then be used to update to the policy's parameters as stored in list \code{theta}.

\figure{3dpolicy.jpeg}{contextual diagram: get context}

* Note: in context-free scenario's, \code{context$X} can be omitted.
}
\section{Usage}{

\preformatted{
  policy <- Policy$new()
}
}

\section{Methods}{


\describe{
\item{\code{new()}}{
Generates and initializes a new \code{Policy} object.
}

\item{\code{get_action(t, context)}}{
arguments:
\itemize{
\item \code{t}: integer, time step \code{t}.
\item \code{context}: list, containing the current \code{context$X} (d x k context matrix),
\code{context$k} (number of arms) and \code{context$d} (number of context features)
}
computes which arm to play based on the current values in named list \code{theta}
and the current \code{context}. Returns a named list containing
\code{action$choice}, which holds the index of the arm to play.
}

\item{\code{set_reward(t, context, action, reward)}}{
arguments:
\itemize{
\item \code{t}: integer, time step \code{t}.
\item \code{context}: list, containing the current \code{context$X} (d x k context matrix),
\code{context$k} (number of arms) and \code{context$d} (number of context features)
(as set by \code{bandit}).
\item \code{action}:  list, containing \code{action$choice} (as set by \code{policy}).
\item \code{reward}:  list, containing \code{reward$reward} and, if available,
\code{reward$optimal} (as set by \code{bandit}).
}
utilizes the above arguments to update and return the set of parameters in list \code{theta}.
}

\item{\code{set_parameters()}}{
Helper function, called during a Policy's initialisation, assigns the values
it finds in list \code{self$theta_to_arms} to each of the Policy's k arms.
The parameters defined here can then be accessed by arm index in the following way:
\code{theta[[index_of_arm]]$parameter_name}.
}

}
}

\seealso{
Core contextual classes: \code{\link{Bandit}}, \code{\link{Policy}}, \code{\link{Simulator}},
\code{\link{Agent}}, \code{\link{History}}, \code{\link{Plot}}

Bandit subclass examples: \code{\link{BasicBernoulliBandit}}, \code{\link{ContextualLogitBandit}},
\code{\link{OfflineReplayEvaluatorBandit}}

Policy subclass examples: \code{\link{EpsilonGreedyPolicy}}, \code{\link{ContextualLinTSPolicy}}
}
