% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{convertToPagoda2}
\alias{convertToPagoda2}
\title{Convert Conos object to Pagoda2 object}
\usage{
convertToPagoda2(con, n.pcs = 100, n.odgenes = 2000, verbose = TRUE, ...)
}
\arguments{
\item{con}{Conos object}

\item{n.pcs}{numeric Number of principal components (default=100)}

\item{n.odgenes}{numeric Number of overdispersed genes (default=2000)}

\item{verbose}{boolean Whether to give verbose output (default=TRUE)}

\item{...}{parameters passed to Pagoda2$new()}
}
\value{
pagoda2 object
}
\description{
Convert Conos object to Pagoda2 object
}
\examples{
\donttest{ 
library(pagoda2)
panel.preprocessed <- lapply(conosPanel::panel, basicP2proc, n.cores=1, min.cells.per.gene=0, 
    n.odgenes=2e3, get.largevis=FALSE, make.geneknn=FALSE)
con <- Conos$new(panel.preprocessed, n.cores=1)
p2object <- convertToPagoda2(con)
}

}
