% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_location_shift.R
\name{ci_mean_diff}
\alias{ci_mean_diff}
\title{CI for the Population Mean Difference}
\usage{
ci_mean_diff(
  x,
  y,
  probs = c(0.025, 0.975),
  var.equal = FALSE,
  type = c("t", "bootstrap"),
  boot_type = c("stud", "bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default c(0.025, 0.975).}

\item{var.equal}{Should the two variances be treated as being equal?
The default is \code{FALSE}. If \code{TRUE}, the pooled variance is used to estimate
the variance of the mean difference. Otherweise, Welch's approach is used.
This also applies to the "stud" bootstrap.}

\item{type}{Type of CI. One of "t" (default), or "bootstrap".}

\item{boot_type}{Type of bootstrap CI ("stud", "bca", "perc", "norm", "basic").
Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{boot::boot()}.}
}
\value{
An object of class "cint" containing these components:
\itemize{
\item \code{parameter}: Parameter specification.
\item \code{interval}: CI for the parameter.
\item \code{estimate}: Parameter estimate.
\item \code{probs}: Lower and upper probabilities.
\item \code{type}: Type of interval.
\item \code{info}: Additional description.
}
}
\description{
This function calculates CIs for the population value of mean(x) - mean(y).
The default is Student's method with Welch's correction for unequal variances,
but also bootstrap CIs are available. The default bootstrap type is "stud"
(bootstrap t) as it has a stable variance estimator (see Efron, p. 188).
Resampling is done within sample. If \code{boot_type = "stud"},
the standard error is estimated by Welch's method if \code{var.equal = FALSE}
(the default), and by pooling otherwise.
Thus, \code{var.equal} not only has an effect for the classic Student approach
(\code{type = "t"}) but also for \code{boot_type = "stud"}.
}
\examples{
x <- 10:30
y <- 1:30
ci_mean_diff(x, y)
t.test(x, y)$conf.int
ci_mean_diff(x, y, type = "bootstrap", R = 999)  # Use larger R
}
\references{
Efron, B. and Tibshirani R. J. (1994). An Introduction to the Bootstrap. Chapman & Hall/CRC.
}
