% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write.config}
\alias{write.config}
\title{Write config in a file (JSON/YAML/INI)}
\usage{
write.config(config.dat, file.path, write.type = "ini",
  encoding = getOption("encoding"), YAML.indent = 2)
}
\arguments{
\item{config.dat}{a list of config (eg. generated by read.config)}

\item{file.path}{file to write}

\item{write.type}{json/ini/yaml}

\item{encoding, }{Encoding of filepath parameter, will default to system
encoding if not specifield}

\item{YAML.indent}{if write.type is yaml, the YAML file indent will be setted by this}
}
\value{
TRUE/FALSE
}
\description{
Write config in a file (JSON/YAML/INI)
}
\examples{
list.test <- list(a=c(123,456))
out.yml <- sprintf('\%s/test.yaml', tempdir()) 
write.config(list.test, out.yml, write.type = 'yaml')
}
\seealso{
\code{\link[jsonlite]{toJSON}} convert a list to JSON string, 
\code{\link[jsonlite]{prettify}} convert a JSON string to user friendly view, 
\code{\link[ini]{write.ini}} write a list in a INI format file, 
\code{\link[yaml]{as.yaml}} convert a list to YAML format.
}

