% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sectionplots.R
\name{sectionPlot}
\alias{sectionPlot}
\title{Plots the main condvis display}
\usage{
sectionPlot(CVdata, CVfit = NULL, response = NULL, preds, sectionvar,
  conditionvals, pointColor = "steelblue", sim = NULL, threshold = 1,
  linecols = NULL, dataplot = "pcp", gridsize = 50, probs = FALSE,
  view3d = FALSE, theta3d = 45, phi3d = 20, xlim = NULL,
  ylim = NULL, zlim = NULL, pointSize = 2, predictArgs = NULL,
  resetpar = TRUE, density = FALSE, showdata = density == FALSE,
  returnCoords = FALSE)
}
\arguments{
\item{CVdata}{the dataset used for the fit}

\item{CVfit}{a fit or list of fits}

\item{response}{name of response variable}

\item{preds}{names of predictors}

\item{sectionvar}{section variable}

\item{conditionvals}{conditioning values. A vector/list or dataframe with one row}

\item{pointColor}{a color, vector of colors,or the name of variable to be used for coloring}

\item{sim}{vector of similarity weights}

\item{threshold}{used for similarity weights, defaults to 1.}

\item{linecols}{vector of line colours}

\item{dataplot}{"pcp" or "pairs". If CVfit is NULL, used to plot the data}

\item{gridsize}{used to construct grid of fitted values.}

\item{probs}{Logical; if \code{TRUE}, shows predicted class probabilities instead of just predicted classes. Only available with two numeric sectionvars and the model's predict method provides this.}

\item{view3d}{Logical; if \code{TRUE} plots a three-dimensional regression surface if possible.}

\item{theta3d, phi3d}{Angles defining the viewing direction. \code{theta3d} gives the azimuthal direction and \code{phi3d} the colatitude. See\code{\link[graphics]{persp}}.}

\item{xlim}{passed on to plot}

\item{ylim}{passed on to plot}

\item{zlim}{passed on to plot}

\item{pointSize}{used for points}

\item{predictArgs}{a list with one entry per fit, giving arguments for predict}

\item{resetpar}{When TRUE (the default) resets pars after drawing.}

\item{density}{default FALSE. Use TRUE if model is a density function.}

\item{showdata}{If FALSE, data on section not shown.}

\item{returnCoords}{If TRUE, returns coordinates for some plots}
}
\value{
plotted coordinates, for some plots
}
\description{
The section plot relates a fit or fits to one or two predictors (\code{sectionvar}), 
for fixed values of other predictors in  \code{conditionvals}.
}
\details{
The type of plot depends on the fit and the section variables. Observations with non zero values of the similarity weights 
\code{sim} are shown. If no fit is provided, the data are shown as a parallel coordinate plot or pairs
plot, depending on \code{dataplot}.
The fit could also be a density estimate.
}
\examples{
#Fit a model. 
f <- lm(Fertility~ ., data=swiss)
svar <- "Education"
preds <- variable.names(f)[-1]
sectionPlot(swiss,f, "Fertility",preds,svar, swiss[12,])
sectionPlot(swiss,f, "Fertility",preds,svar, apply(swiss,2,median))
sectionPlot(swiss,f, "Fertility",preds,preds[1:2], apply(swiss,2,median))
sectionPlot(swiss,f, "Fertility",preds,preds[1:2], apply(swiss,2,median), view3d=TRUE)

# PCP of swiss data, showing only cases whose percent catholic and infant.mortality are
# similar to those of the first case
sectionPlot(swiss,preds=names(swiss),
           sectionvar= names(swiss)[1:4],conditionvals=swiss[1,] )     
# Use dataplot="pairs" to switch to a pairs plot

# A density estimate example
 \dontrun{
 library(ks)
fde <-kde(iris[,1:3])
sectionPlot(iris,list(kde=fde), response=NULL,
           preds=names(iris)[1:3],
           sectionvar=names(iris)[1],
           conditionvals=iris[1,],density=TRUE)
 }
}
