% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrangeC.R
\name{arrangeC}
\alias{arrangeC}
\title{Make a list of variable pairings for condition selecting plots
produced by plotxc}
\usage{
arrangeC(data, method = "default")
}
\arguments{
\item{data}{A dataframe}

\item{method}{The character name for the method to use for measuring
bivariate dependency, passed to \code{\link{savingby2d}}.}
}
\value{
A list containing character vectors giving variable pairings.
}
\description{
This function arranges a number of variables in pairs, ordered
by their bivariate relationships. The goal is to discover which variable
pairings are most helpful in avoiding extrapolations when exploring the data
space. Variable pairs with strong bivariate dependencies (not necessarily
linear) are chosen first. The bivariate dependency is measured using
\code{\link{savingby2d}}. Each variable appears in the output only once.
}
\details{
If \code{data} is so big as to make \code{arrangeC} very slow, a
  random sample of rows is used instead. The bivariate dependency measures
  are rough, and the ordering algorithm is a simple greedy one, so it is not
  worth allowing it too much time. This function exists mainly to provide a
  helpful default ordering/pairing for \code{\link{ceplot}}.
}
\examples{
data(powerplant)

pairings <- arrangeC(powerplant)

dev.new(height = 2, width = 2 * length(pairings))
par(mfrow = c(1, length(pairings)))

for (i in seq_along(pairings)){
 plotxc(powerplant[, pairings[[i]]], powerplant[1, pairings[[i]]],
   select.col = NA)
}
}
\seealso{
\code{\link{savingby2d}}
}

