% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_condition.R, R/autogenerated.R
\name{as_message}
\alias{as_assertion_error}
\alias{as_assertion_message}
\alias{as_assertion_warning}
\alias{as_deprecated_error}
\alias{as_deprecated_message}
\alias{as_deprecated_warning}
\alias{as_dimension_error}
\alias{as_dimension_message}
\alias{as_dimension_warning}
\alias{as_error}
\alias{as_future_error}
\alias{as_future_message}
\alias{as_future_warning}
\alias{as_index_error}
\alias{as_index_message}
\alias{as_index_warning}
\alias{as_io_error}
\alias{as_io_message}
\alias{as_io_warning}
\alias{as_length_error}
\alias{as_length_message}
\alias{as_length_warning}
\alias{as_library_error}
\alias{as_library_message}
\alias{as_library_warning}
\alias{as_lookup_error}
\alias{as_lookup_message}
\alias{as_lookup_warning}
\alias{as_message}
\alias{as_missing_error}
\alias{as_missing_message}
\alias{as_missing_warning}
\alias{as_name_error}
\alias{as_name_message}
\alias{as_name_warning}
\alias{as_runtime_error}
\alias{as_runtime_message}
\alias{as_runtime_warning}
\alias{as_type_error}
\alias{as_type_message}
\alias{as_type_warning}
\alias{as_value_error}
\alias{as_value_message}
\alias{as_value_warning}
\alias{as_warning}
\title{Convert Conditions}
\usage{
as_message(class, message = NULL)

as_warning(class, message = NULL)

as_error(class, message = NULL)

as_assertion_message(message = NULL)

as_deprecated_message(message = NULL)

as_dimension_message(message = NULL)

as_future_message(message = NULL)

as_index_message(message = NULL)

as_io_message(message = NULL)

as_length_message(message = NULL)

as_library_message(message = NULL)

as_lookup_message(message = NULL)

as_missing_message(message = NULL)

as_name_message(message = NULL)

as_runtime_message(message = NULL)

as_type_message(message = NULL)

as_value_message(message = NULL)

as_assertion_warning(message = NULL)

as_deprecated_warning(message = NULL)

as_dimension_warning(message = NULL)

as_future_warning(message = NULL)

as_index_warning(message = NULL)

as_io_warning(message = NULL)

as_length_warning(message = NULL)

as_library_warning(message = NULL)

as_lookup_warning(message = NULL)

as_missing_warning(message = NULL)

as_name_warning(message = NULL)

as_runtime_warning(message = NULL)

as_type_warning(message = NULL)

as_value_warning(message = NULL)

as_assertion_error(message = NULL)

as_deprecated_error(message = NULL)

as_dimension_error(message = NULL)

as_future_error(message = NULL)

as_index_error(message = NULL)

as_io_error(message = NULL)

as_length_error(message = NULL)

as_library_error(message = NULL)

as_lookup_error(message = NULL)

as_missing_error(message = NULL)

as_name_error(message = NULL)

as_runtime_error(message = NULL)

as_type_error(message = NULL)

as_value_error(message = NULL)
}
\arguments{
\item{class}{[\code{character}]\cr
New classes for the condition.}

\item{message}{[\code{character}]\cr
If provided, overwrites the original condition message.}
}
\value{
[\code{function}]. Returns a function which takes a condition as first
  argument, creates a new condition of the respective type and signals the created
  condition with \code{\link[base]{message}}, \code{\link[base]{warning}} or
  \code{\link[base]{stop}}, respectively.
}
\description{
These functions are intended to change the class of conditions.
In combination with \code{\link[base]{tryCatch}}, unspecified conditions
can easily be casted to a more specific type.
See \code{\link{condition}} for a short explanation about the predefined
condition classes.
}
\examples{
# Turn the warning of sqrt() into a value message
message(tryCatch(sqrt(-1), warning = as_value_message()))

\dontrun{
# Turn the warning of sqrt() into a value error
tryCatch(sqrt(-1), warning = as_value_error())

# Or, alternatively with a custom message:
tryCatch(sqrt(-1), warning = as_value_error("sqrt of negative value"))
}
}

