% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comradesDataSet.R
\docType{class}
\name{comradesDataSet-class}
\alias{comradesDataSet-class}
\alias{comradesDataSet}
\title{comradesDataSet}
\usage{
comradesDataSet(rnas, rnaSize = 0, sampleTable)
}
\arguments{
\item{rnas}{vector - The names of the RNA interest, these must be displayed
the same way as in the input Hyb Files.}

\item{rnaSize}{named list - The sizes (nt) of the RNAs of interest, the list
elements must have same names as the \code{rnas} vector and each each contain
one numeric value.}

\item{sampleTable}{string - The address of the sample table, the sample table
must have 4 columns, fileName (the full path and file name of the input
hyb file for each sample ), group ("s" - sample or "c" - control),
sample (1,2,3, etc), sampleName (must be unique).}
}
\value{
A comradesDataSet object.
}
\description{
\code{comradesDataSet} objects are used to store the input meta-data, data and
create a framework for the storage of results. Whilst creating the object,
the original hyb files are also filtered for the RNA of interest. Check the 
package vignette for more information.
}
\section{Slots}{

\describe{
\item{\code{clusterTableFolded}}{table - a table similar to the \code{clusterTableList}
it contains coordinates of the clusters along with vienna format fold and
RNA sequences for each cluster}

\item{\code{clusterTableList}}{List - Follows the pattern for list slots of comradesDataSet
objects, \code{matrixList(cds)[[rna]][[type]][[sample]]}. contains a table
with coordinates and information about the clusters identified}

\item{\code{clusterGrangesList}}{List - Follows the pattern for list slots of comradesDataSet
objects, \code{matrixList(cds)[[rna]][[type]][[sample]]}. contains GRanges
objects of the original duplexes with their cluster membership}

\item{\code{sampleTable}}{table - Column names; fileName, group (s or c),
sample (1,2,3, etc), sampleName (must be unique)}

\item{\code{rnas}}{string - a single RNA to analyse - must be present in \code{rnas(cdsObject)}}

\item{\code{rnaSize}}{if set to 0 this will be calculated}

\item{\code{matrixList}}{List - Follows the pattern for list slots of comradesDataSet
objects, \code{matrixList(cds)[[rna]][[type]][[sample]]}. Contains a set
of contact matrices, each cell contains the number of duplexes identified
for position x,y.}

\item{\code{hybFiles}}{List - Follows the pattern for list slots of comradesDataSet
objects, \code{hybFiles(cds)[[rna]][[type]][[sample]]}. Contains a set of
tables, these are the original Hyb files that were read in.}

\item{\code{interactionTable}}{Table of interactions discovered in step1 of the folding}

\item{\code{viennaStructures}}{List of vienna format structures from final prediction}

\item{\code{dgs}}{List of free energies}
}}

\examples{
# make example input
c4 = c(rep("transcript1",100),rep("transcript2",100) )
c10 = c(rep("transcript1",200) )
c1 = 1:200
c2 = rep(paste(rep("A", 40), collapse = ""),200)
c3 = rep(".",200)
c9 = rep(".",200)
c15 = rep(".",200)
c5 = rep(1,200)
c11 = rep(21,200)
c6 = rep(20,200)
c12= rep(40,200)
# short distance 50
c7 = sample(1:5, 50, replace = TRUE)
c8 = sample(20:25, 50, replace = TRUE)
c13 = sample(20:25, 50, replace = TRUE)
c14 = sample(40:45, 50, replace = TRUE)
# long distance 50
c7 = c(c7,sample(1:5, 50, replace = TRUE))
c8 = c(c8,sample(20:25, 50, replace = TRUE))
c13 = c(c13,sample(60:70, 50, replace = TRUE))
c14 = c(c14,sample(80:83, 50, replace = TRUE))
# inter RNA 100
c7 = c(c7,sample(1:5, 100, replace = TRUE))
c8 = c(c8,sample(20:25, 100, replace = TRUE))
c13 = c(c13,sample(1:5, 100, replace = TRUE))
c14 = c(c14,sample(20:25, 100, replace = TRUE))
exampleInput = data.frame(V1 = c1,
                         V2 = c2,
                         V3 = c3,
                         V4 = c4,
                         V5 = as.numeric(c5),
                         V6 = as.numeric(c6),
                         V7 = as.numeric(c7),
                         V8 = as.numeric(c8),
                         V9 = c9,
                         V10 = c10,
                         V11 = as.numeric(c11),
                         V12 = as.numeric(c12),
                         V13 = as.numeric(c13),
                         V14 = as.numeric(c14),
                         V15 = c15)
file = tempfile()
write.table(exampleInput,file = file, 
quote = FALSE, 
row.names = FALSE, sep = "\t", col.names = FALSE)


# Set up the sample table 
sampleTabler1 = c(file, "s", "1", "s1")
sampleTabler2 = c(file, "c", "1", "c1")
# make the sample table 
sampleTable2 = rbind.data.frame(sampleTabler1, sampleTabler2)
# add the column names 
colnames(sampleTable2) = c("file", "group", "sample", "sampleName")

# Choose RNA and set up the object ----
rna = c("transcript1")


# load the object
cds = comradesDataSet(rnas = rna,
                     rnaSize = 0,
                     sampleTable = sampleTable2)

cds

}
