% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{labels.data.frame}
\alias{labels.data.frame}
\alias{labels<-}
\title{Get or set labels for a data frame}
\usage{
\method{labels}{data.frame}(object, ...)

labels(x) <- value
}
\arguments{
\item{object}{A data frame or tibble.}

\item{...}{Follow-on parameters.  Required for generic function.}

\item{x}{A data frame or tibble}

\item{value}{A named list of labels. The labels must be quoted strings.}
}
\value{
A named list of labels. The labels must be quoted strings.
}
\description{
The \code{labels} function extracts all assigned labels from a
data frame, and returns them in a named list. The function also
assigns labels from a named list.  This function is a data frame-specific
implementation of the Base R \code{\link[base]{labels}} function.
}
\details{
If labels are assigned to the "label" attributes of the data frame
columns, the \code{labels} function will extract those labels.  The
function will return the labels in a named list, where the names
correspond to the name of the column that the label was assigned to.
If a column does not have a label attribute assigned, that column
will not be included in the list.

When used on the receiving side of an assignment, the function will assign
labels to a data frame.  The labels should be in a named list, where
each name corresponds to the data frame column to assign the label to.

Finally, if you wish to clear out the label attributes, assign
a NULL value to the \code{labels} function.
}
\examples{
# Take subset of data
df1 <- mtcars[1:10, c("mpg", "cyl") ]

# Assign labels
labels(df1) <- list(mpg = "Mile Per Gallon", cyl = "Cylinders")

# Examine attributes
str(df1)
# 'data.frame':	10 obs. of  2 variables:
# $ mpg: num  21 21 22.8 21.4 18.7 18.1 14.3 24.4 22.8 19.2
# ..- attr(*, "label")= chr "Mile Per Gallon"
# $ cyl: num  6 6 4 6 8 6 8 4 4 6
# ..- attr(*, "label")= chr "Cylinders"

# View assigned labels
labels(df1)
# $mpg
# [1] "Mile Per Gallon"
#
# $cyl
# [1] "Cylinders"

# Clear labels
labels(df1) <- NULL

# Display Cleared Labels
labels(df1)
# list()
}
