% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcaPMV.R
\name{calcaPMV}
\alias{calcaPMV}
\alias{aPMV}
\alias{apmv}
\title{Adaptive Predicted Mean Votes}
\usage{
calcaPMV(ta, tr, vel, rh, clo = 0.5, met = 1, wme = 0, apCoeff)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{wme}{a numeric value presenting external work in [met]}

\item{apCoeff}{adaptive coefficient lambda}
}
\value{
\code{calcaPMV} returns the predicted mean vote adjusted through the adaptive coefficients.
}
\description{
Function to calculate adaptive Predicted Mean Vote (aPMV) adjusted through the adaptive coefficient.
}
\details{
\code{apCoeff} can be derived using \code{calcapCoeff}.
}
\note{
In case one of \code{apCoeff} is not given, a standard value will be taken from a list (see \code{\link{createCond}} for details.
}
\examples{
## Note. Due to random generated asv values. The values for the coefficients will not be meaningful.
## Create sample data
ta  <- 20:24     # vector with air temperature values
tr  <- ta         # vector with radiant temperature values
vel <- rep(.1,5)  # vector with air velocities
rh  <- rep(50,5)  # vector with relative humidity values
clo <- rep(1.0,5) # vector with clo values
met <- rep(1.1,5) # vector with metabolic rates
asv <- rnorm(5)   # vector with actual sensation votes
lsCond <- as.list(data.frame(ta,tr,vel,rh,clo,met,asv))
## Calculate coefficient apCoeff for data set
apCoeff <- calcapCoeff(lsCond)
## calculate apmv
apmv <- NULL
for (i in 1:length(ta)){
 apmv[i] <- calcaPMV(ta[i], tr[i], vel[i], rh[i], clo[i], met[i], apCoeff = apCoeff)$apmv}
apmv
}
\references{
aPMV is based on Yao, Li and Liu (2009) <doi:10.1016/j.buildenv.2009.02.014>
}
\seealso{
\code{\link{calcComfInd}}, \code{\link{calcapCoeff}}
}
\author{
Code implemented in to R by Marcel Schweiker. Further contribution by Sophia Mueller and Shoaib Sarwar.
}
