% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPMVadj.R
\name{calcPMVadj}
\alias{calcPMVadj}
\alias{PMVadj}
\alias{pmvadj}
\title{Predicted Mean Votes adjusted for elevated air speed}
\usage{
calcPMVadj(ta, tr, vel, rh, clo, met, wme = 0)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{wme}{a numeric value presenting external work in [met]}
}
\value{
\code{calcpmvadj} returns the predicted mean vote adjusted for the cooling effect of elevated air speed.
}
\description{
Function to calculate Predicted Mean Votes (PMV) adjusted for cooling effect of elevated air speed.
}
\details{
Calculated through function Two node model(\code{calc2Node}
}
\examples{
calcPMVadj(25,25,0.3,50,0.5,1)
}
\references{
pmvadj is based on ASHRAE standard 55-2013. Thermal environmental conditions for human occupancy. American society of heating, Refrigerating and Air-Conditioning Engineering, Atlanta, USA, 2013.
}
\author{
Code implemented in to R by Marcel Schweiker. Further contribution by Sophia Mueller and Shoaib Sarwar.
}
