% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c4a_scores.R
\name{c4a_scores}
\alias{c4a_scores}
\title{Get information from a cols4all palette}
\usage{
c4a_scores(
  palette = NULL,
  type = NULL,
  series = NULL,
  n = NA,
  no.match = c("message", "error", "null"),
  verbose = TRUE
)
}
\arguments{
\item{palette}{name of the palette}

\item{type}{type of palettes (in case palette is not specified)}

\item{series}{series name (in case palette is not specified)}

\item{n}{number of colors}

\item{no.match}{what happens is no match is found? Options: \code{"message"}: a message is thrown with suggestions, \code{"error"}: an error is thrown, \code{"null"}: \code{NULL} is returned}

\item{verbose}{should messages be printed?}
}
\value{
list with the following items: name, series, fullname, type, palette (colors), na (color), nmax, and reverse. The latter is \code{TRUE} when there is a \code{"-"} prefix before the palette name.
}
\description{
Get information from a cols4all palette
}
\examples{
c4a_scores("blues3")

pals = c4a_palettes(type = "cat")
scores_cat7 = t(sapply(pals, c4a_scores, n = 7))

head(scores_cat7)
}
