% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c4a_options.R
\name{c4a_options}
\alias{c4a_options}
\title{Set cols4all options}
\usage{
c4a_options(...)
}
\arguments{
\item{...}{Use character values to retrieve options. To set options, either use named arguments (where the names refer to the options), a list that consists of those options.}
}
\value{
A list of options
}
\description{
Get or set global options for c4a. Works similar as the base function \code{options}
}
\details{
\tabular{ll}{
   \strong{Option} \tab \strong{Description} \cr
   defaults \tab Default palettes per type \cr
   CBF_th \tab Parameters that label a palette as color blind friendly \cr
   CBVF_th \tab Parameters that label a palette as very color blind friendly \cr
   CBU_th \tab Parameters that label a palette as color blind unfriendly \cr
   CrangeFair \tab Maximum chroma range for which a palette is considered harmonic \cr
   CrangeUnfair \tab Minimum chroma range for which a palette is considered disharmonic \cr
   LrangeFair \tab Maximum luminance range for which a palette is considered harmonic \cr
   LrangeUnfair \tab Minimum luminance range for which a palette is considered disharmonic \cr
   Cintense \tab Chroma of colors that are considered intense \cr
   Cpastel \tab Chroma of colors that are considered 'pastel' \cr
   HwidthDivRainbow \tab A diverging palette is labeled as 'rainbow hue' if HwidthL or HwidthR are at least \code{HwidthDivRainbow} \cr
   HwidthDivSingle \tab A diverging palette is labeled as 'single hue' if HwidthL and HwidthR are at most \code{HwidthDivSingle} \cr
   HwidthSeqRainbow \tab A sequential palette is labeled as 'rainbow hue' if Hwidth is at least \code{HwidthSeqRainbow} \cr
   HwidthSeqSingle \tab A sequential palette is labeled as 'single hue' if Hwidth is at most \code{HwidthSeqSingle} \cr
   naming_fun \tab Function that returns a distance matrix with the \code{naming_colors} (see examples) \cr
   naming_fun_args \tab List of arguments for \code{naming_fun} \cr
   naming_colors \tab Vector of prototype colors for the color names (see examples) \cr
   naming_softmax \tab List of parameters for the softmax function applied to the distance matrix \cr
}
}
\examples{
# Example how to lower the color-blind friendly threshold
# for categorical palettes (so more smileys in the GUI!)
# CBF_th: one smiley
# CBVF_th: two smileys

# current table
\dontrun{
c4a_table(n = 9, sort = "cbfriendly")

opts = c4a_options("CBF_th", "CBVF_th")
opts$CBF_th$cat["min_dist"] = 7
opts$CBVF_th$cat["min_dist"] = 10


old = c4a_options(opts)

# more smileys :-) :-)
c4a_table(n = 9, sort = "cbfriendly")

# set the old settings back
c4a_options(old)
}

# Example how to use own nameability function
#
# This function should:
# - have an argument "pal" (vector of colors)
# - optionally have other arguments
# - return a distance matrix of n rows (length of pal) and k columns (classes).
#   It shoud have columns names that correspond to the naming colors (see below).
naming_RGB = function(pal) {
	cols = colorspace::hex2RGB(pal)
	coords = cols@coords

	cls = apply(coords, MARGIN = 1, which.max)
	mx = apply(coords, MARGIN = 1, max)
	dominance = ((mx + 0.001) / (rowSums(coords) + 0.001))
	cls[dominance < 0.4] = 4L

	m = matrix(0, nrow = length(pal), ncol = 4,
        dimnames = list(NULL, c("Red", "Green", "Blue", "Other")))
	for (i in 1:nrow(m)) {
		m[i, cls[i]] = 1
	}

	-m
}

# testing this function...
naming_RGB(c4a("brewer.set1")) #fair enough

# This vector should contain the 'prototype' colors, and have names that correspond
# to the column names of the returned matrices by the function above.
names_RGB =
    c("Red" = "#FF0000",
      "Green" = "#00FF00",
      "Blue" = "#0000FF",
      "Other" = "#AAAAAA")

# Set the options (may take a while because if calculated the nameability scores)
\dontrun{
c4a_options(naming_fun = naming_RGB,
			naming_fun_args = list(),
			naming_colors = names_RGB)
}
}
