% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleColor.R
\name{scaleColor}
\alias{scaleColor}
\title{scaleColor}
\usage{
scaleColor(palette = "pabloHoney", discrete = TRUE, ...)
}
\arguments{
\item{palette}{A character string specifying the name of the color palette.
The palette must be present in either 'taylor_palettes' or 'radiohead_palettes'.}

\item{discrete}{A logical value indicating whether to create a discrete (TRUE)
or continuous (FALSE) color scale. Default is TRUE.}

\item{...}{Additional arguments to be passed to the ggplot2 scale function.}
}
\value{
A ggplot2 colour scale based on the specified color palette.
}
\description{
Create a Custom Color Scale for ggplot2. This function creates a custom color
scale for ggplot2 plots based on the specified 'palette' name.
The color palettes are sourced from two predefined
lists: 'taylor_palettes' and 'radiohead_palettes'.
The function can create either a discrete or continuous
color scale, depending on the 'discrete' parameter.
Additional arguments passed to the function are forwarded to the corresponding ggplot2 scale function.
}
