% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{get_crypto_ohlcv}
\alias{get_crypto_ohlcv}
\title{List latest/historical OHLCV values}
\usage{
get_crypto_ohlcv(currency = "USD", latest = TRUE, symbol = NULL,
  id = NULL, ...)
}
\arguments{
\item{currency}{currency code - Default is 'USD'}

\item{latest}{If `TRUE` (default), only the latest data is retrieved,
otherwise historical data is returned.}

\item{symbol}{One or more cryptocurrency symbols.
Example: c("BTC","ETH").}

\item{id}{Alternatively pass one or more CoinMarketCap cryptocurrency IDs.
Example: c(1,2)}

\item{...}{Further arguments passed to the request. Further information
can be found in the \href{https://coinmarketcap.com/api/documentation/v1/#operation}{API documentation}}
}
\value{
A dataframe with OHLCV values
}
\description{
Return the latest/historical OHLCV (Open, High, Low, Close, Volume) market values for
one or more cryptocurrencies for the current UTC day. Since the current UTC
day is still active these values are updated frequently. You can find the
final calculated OHLCV values for the last completed UTC day along with
all historic days using /cryptocurrency/ohlcv/historical.
}
\note{
One of "id" or "symbol" is required for this request.
}
\examples{
\dontrun{
get_crypto_ohlcv("EUR")
get_crypto_ohlcv("EUR", latest = F)
get_crypto_ohlcv("EUR", latest = F, time_period = "hourly",
                 time_start=Sys.Date()-180, count=5, interval="monthly")
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1CryptocurrencyOhlcvLatest}{API documentation}
}
\seealso{
Other Cryptocurrencies: \code{\link{get_crypto_listings}},
  \code{\link{get_crypto_map}},
  \code{\link{get_crypto_marketpairs}},
  \code{\link{get_crypto_meta}},
  \code{\link{get_crypto_quotes}},
  \code{\link{get_marketcap_ticker_all}},
  \code{\link{get_valid_currencies}}
}
\concept{Cryptocurrencies}
