% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-comp.R
\name{ConceptIndicSummary}
\alias{ConceptIndicSummary}
\title{Summary table on concept comparisons by indicator}
\usage{
ConceptIndicSummary(project, units)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}
}
\value{
A data frame
}
\description{
Summary table on concept comparisons by indicator
}
\details{
This function produce a summary table based on concept comparisons by indicator.
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

## More documents are needed for running this function
## ConceptIndicSummary(my.project, units = c("Belgium", "Québec"))
}
