% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance_difference.R
\name{abundance_difference}
\alias{abundance_difference}
\title{Abundance Differences}
\usage{
abundance_difference(df, time.var = NULL, species.var, abundance.var,
  replicate.var, treatment.var = NULL, pool = FALSE, block.var = NULL,
  reference.treatment = NULL)
}
\arguments{
\item{df}{A data frame containing species, abundance, replicate columns and   optional time, treatment and block columns.}

\item{time.var}{The name of the optional time column}

\item{species.var}{The name of the species column}

\item{abundance.var}{The name of the abundance column}

\item{replicate.var}{The name of the replicate column. Replicate must be unique within the dataset and cannot be nested within treatments or blocks.}

\item{treatment.var}{The name of the optional treatment column}

\item{pool}{An argument to allow abundance values to be pooled within a
treatment. The default value is "FALSE", a value of "TRUE" averages the
abundances of each species within a treatment at a given time point.}

\item{block.var}{The name of the optional block column}

\item{reference.treatment}{The name of the optional treatment that all other treatments will be compared to (e.g. only controls will be compared to all other treatments). If not specified all pairwise treatment comparisons will be made.}
}
\value{
The abundance_difference function returns a data frame with the
  following attributes:
\itemize{
 \item{species.var: }{A column that has same name and type as the species.var column.}
 \item{difference: }{A numeric column of the abundance differences between the two samples being compared (replicates or treatments). A numeric column of the change in abundance between consecutive timepoints. A positive value occurs when a species has greater abundance in replicate.var2 than in replicate.var and/or in treatment.var2 than in treatment.var.}
 #'  \item{replicate.var: }{A column that has same name and type as the replicate.var column, represents the first replicate being compared. Note, a replicate column will be returned only when pool = FALSE or block.var = NULL.}
 \item{replicate.var2: }{A column that has the same type as the replicate.var column, and is named replicate.var with a 2 appended to it, represents the second replicate being compared. Note, a replicate.var column will be returned only when pool = FALSE and block.var = NULL.}
 \item{time.var: }{A column that has the same name and type as the time.var column, if time.var is specified.}
 \item{treatment.var: }{A column that has same name and type as the treatment.var column, represents the first treatment being compared. A treatment.var column will be returned when pool = TRUE, block.var is specified, or treatment.var is specified.}
 \item{treatment.var2: }{A column that has the same type as the treatment.var column, and is named treatment.var with a 2 appended to it, represents the second treatment being compared. A treatment.var column will be returned when pool = TRUE, block.var is specified, or treatment.var is specified.}
 \item{block.var: }{A column that has same name and type as the block.var column, if block.var is specified.}
}
}
\description{
Calculates the abundance difference for species between two   samples. Differences are on abundance values provided, if relative data is   used, then differences in relative abundance will be calculated. There are three ways differences can be calculated. 1) Between treatments within a block (note: block.var and treatment.var need to be specified). 2) Between treatments, pooling all replicates into a single species pool (note: pool = TRUE, treatment.var needs to be specified, and block.var = NULL). 3) All pairwise combinations between all replicates (note: block.var = NULL, pool = FALSE and specifying treatment.var is optional. If treatment.var is specified, the treatment that each replicate belongs to will also be listed in the output).
}
\examples{
data(pplots)
# With block and no time
df <- subset(pplots, year == 2002 & block < 3)
abundance_difference(df = df,
                     species.var = "species",
                     abundance.var = "relative_cover",
                     treatment.var = "treatment",
                     block.var = "block",
                     replicate.var = "plot")

# With blocks and time
df <- subset(pplots, year < 2004 & block < 3)
abundance_difference(df = df,
                     species.var = "species",
                     abundance.var = "relative_cover",
                     treatment.var = "treatment",
                     block.var = "block",
                     replicate.var = "plot",
                     time.var = "year")

# With blocks, time and reference treatment
df <- subset(pplots, year < 2004 & block < 3)
abundance_difference(df = df,
                     species.var = "species",
                     abundance.var = "relative_cover",
                     treatment.var = "treatment",
                     block.var = "block",
                     replicate.var = "plot",
                     time.var = "year",
                     reference.treatment = "N1P0")
                     
# Pooling by treatment with time
df <- subset(pplots, year < 2004)
abundance_difference(df = df,
                     species.var = "species",
                     abundance.var = "relative_cover",
                     treatment.var = "treatment",
                     pool = TRUE,
                     replicate.var = "plot",
                     time.var = "year")

# All pairwise replicates with treatment
df <- subset(pplots, year < 2004 & plot \%in\% c(21, 25, 32))
abundance_difference(df = df,
                     species.var = "species",
                     abundance.var = "relative_cover",
                     replicate.var = "plot",
                     time.var = "year",
                     treatment.var = "treatment")

# All pairwise replicates without treatment
df <- subset(pplots, year < 2004 & plot \%in\% c(21, 25, 32))
abundance_difference(df = df,
                     species.var = "species",
                     abundance.var = "relative_cover",
                     replicate.var = "plot",
                     time.var = "year")
}
\references{
Avolio et al. Submitted to MEE
}
