% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synchrony.R
\name{synchrony}
\alias{synchrony}
\title{Species synchrony}
\usage{
synchrony(df, time.var = "year", species.var = "species",
  abundance.var = "abundance", metric = "Loreau", replicate.var = NA)
}
\arguments{
\item{df}{A data frame containing time, species and abundance columns and an optional column of replicates}

\item{time.var}{The name of the time column}

\item{species.var}{The name of the species column}

\item{abundance.var}{The name of the abundance column}

\item{metric}{The synchrony metric to return:
\itemize{
 \item{"Loreau": }{The default metric, calculates synchrony following Loreau and de Mazancourt (2008).}
 \item{"Gross": }{Calculates synchrony following Gross et al. (2014).}
}}

\item{replicate.var}{The name of the optional replicate column}
}
\value{
The \code{synchrony} function returns a numeric synchrony value unless a replication column is specified in the input data frame. 
If replication is specified, the function returns a data frame with the following attributes:
\itemize{
 \item{synchrony: }{A numeric column with the synchrony values.}
 \item{replicate.var: }{A column that shares the same name and type as the replicate.var column in the input data frame.}
}
}
\description{
Calculates the degree synchrony in species abundances within a community over time. 
Includes the option for two different synchrony metrics. The first, developed by Loreau and de Mazancourt (2008), compares the variance of the aggregated community with the variance of individual components.
The second, developed by Gross et al. (2014), compares the average correlation of each individual species with the rest of the aggregated community.
}
\details{
The input data frame needs to contain columns for time, species and abundance; time.var, species.var and abundance.var are used to indicate which columns contain those variables.
If multiple replicates are included in the data frame, that column should be specified with replicate.var. Each replicate should reflect a single experimental unit - there must be a single abundance value per species within each time point and replicate.
}
\examples{
data(knz_001d)
synchrony(knz_001d[knz_001d$subplot=="A_1",]) # for one subplot
\dontrun{
synchrony(knz_001d, replicate.var = "subplot") # across all subplots
synchrony(knz_001d, replicate.var = "subplot", metric="Gross") # With Gross et al. (2014) metric.
}
}
\references{
Gross, Kevin, Bradley J. Cardinale, Jeremy W. Fox, Andrew Gonzalez, Michel Loreau, H. Wayne Polley, Peter B. Reich, and Jasper van Ruijven. (2014) "Species richness and the temporal stability of biomass production: A new analysis of recent biodiversity experiments." The American Naturalist 183, no. 1: 1-12. doi:10.1086/673915.

Loreau, Michel, and Claire de Mazancourt. (2008) "Species synchrony and its drivers: Neutral and nonneutral community dynamics in fluctuating environments." The American Naturalist 172, no. 2: E48-66. doi:10.1086/589746.
}

