% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_extra.R
\name{Codings}
\alias{Codings}
\alias{code_control}
\alias{code_control_last}
\alias{code_diff}
\alias{code_diff_forward}
\alias{code_helmert}
\alias{code_helmert_forward}
\alias{code_deviation}
\alias{code_deviation_first}
\alias{code_poly}
\alias{contr.diff}
\title{Coding matrix functions for factors in linear model formulae}
\usage{
code_control(n, contrasts = TRUE, sparse = FALSE)

code_control_last(n, contrasts = TRUE, sparse = FALSE)

code_diff(n, contrasts = TRUE, sparse = FALSE)

code_diff_forward(n, contrasts = TRUE, sparse = FALSE)

code_helmert(n, contrasts = TRUE, sparse = FALSE)

code_helmert_forward(n, contrasts = TRUE, sparse = FALSE)

code_deviation(n, contrasts = TRUE, sparse = FALSE)

code_deviation_first(n, contrasts = TRUE, sparse = FALSE)

code_poly(n, contrasts = TRUE, sparse = FALSE)

contr.diff(n, contrasts = TRUE, sparse = FALSE)
}
\arguments{
\item{n}{Either a positive integer giving the number of levels or the levels
attribute of a factor, supplying both the number of levels via its length and
labels potentially to be used in the \code{dimnames} of the result.}

\item{contrasts}{Logical: Do you want the \eqn{n \times (n-1)}{n x (n-1)} coding
matrix (\code{TRUE}) or an \eqn{n \times n}{n x n} full-rank matrix, (as is
sometimes needed by the fitting functions) (\code{FALSE})?}

\item{sparse}{Logical: Do you want the result to be a sparse matrix
object, as generated the the \code{Matrix} package?}
}
\value{
A coding matrix, as requested by fitting functions using linear
   model formulae with factor predictors.
}
\description{
These functions provide an alternative to the coding functions supplied
in the \code{stats} package, namely \code{contr.treatment}, \code{contr.sum},
\code{contr.helmert} and \code{contr.poly}.
}
\details{
All functions with names of the form \code{code_xxxx} return
  coding matrices which, in a simple model, make the intercept term
  the simple ("unweighted") average of the class means.  This can be
  important in some non-standard ANOVA tables.  The function
  \code{contr.diff} is an exception, and is offered as a natural companion
  to \code{stats::contr.treatment}, with which it is closely aligned.
\describe{
\item{code_control}{Similar to \code{\link[stats]{contr.treatment}}, with
                    contrasts comparing the class means (the "treatments") with
                    the first class mean (the "control").}
\item{code_control_last}{Similar to \code{code_control}, but using the final
                    class mean as the "control".  Cf. \code{\link[stats]{contr.SAS}}}
\item{code_diff}{The contrasts are the successive differences of the treatment means,
   \eqn{\mu_{i+i} - \mu_i}{mu(i+1) - mu(i)}.  This coding function has no counterpart in the \code{stats}
   package.  It is suggested as an alternative to the default coding,
   \code{\link[stats]{contr.poly}}, for
   ordered factors.  It offers a visual check of monotonicity of the class means
   with the ordered levels of the factor.  Unlike \code{stats::contr.poly}
   there is no assumption that the factor levels
   are in some sense "equally spaced".}
\item{code_diff_forward}{Very similar to \code{code_diff}, but using forward
   differences: \eqn{\mu_i - \mu_{i+1}}{mu(i) - mu(i+1)}}
\item{code_helmert}{Similar to \code{\link[stats]{contr.helmert}}, but with a
   small scaling change to make the regression coefficients (i.e. the contrasts)
   more easily interpretable.  The contrasts now compare each class mean, starting
   from the second, with the average of all class means coming prior to it in the
   factor levels order.}
\item{code_helmert_forward}{Similar to \code{code_helmert}, but comparing each class
   mean, up to the second last, with the average of all class means coming after it in
   the factor levels order.}
\item{code_deviation}{Similar to \code{\link[stats]{contr.sum}}, which is described
   as having the "effects" summing to zero.  A more precise description might be to
   say that the contrasts are the deviations of each class mean from the average
   of them, i.e. \eqn{\mu_i - \bar\mu}{mu(i) - mu_bar}.  To avoid redundancy, the
   last deviation is omitted.}
\item{code_deviation_first}{Very similar to \code{code_deviation}, but omitting
   the first deviation to avoid redundancy rather than the last.}
\item{code_poly}{Similar in effect to \code{\link[stats]{contr.poly}} but
   for levels fewer than 15 using an unnormalized basis for the orthogonal polynomials
   with integer entries.  (Orthogonal polynomials were originally given in this form
   as tables.)  The only advantage over \code{stats::contr.poly} is one of display.
   Use \code{stats::contr.poly} in preference other than for teaching purposes.}
\item{contr.diff}{Very similar in effect to \code{code_diff}, yielding the same
   differences as the contrasts, but like \code{stats::contr.treatment} using the
   first class mean as the intercept coefficient rather than the simple average of
   the class means, as with \code{code_diff}.  Some would regard this as making it
   unsuitable for use in some non-standard ANOVA tables.}
}
}
\examples{
(M <- code_control(5))
mean_contrasts(M)
(M <- stats::contr.treatment(5))
mean_contrasts(M)  ## same contrasts; different averaging vector.
mean_contrasts(stats::contr.helmert(6))  ## Interpretation obscure
mean_contrasts(code_helmert(6))          ## each mean with the average preceding
mean_contrasts(code_helmert_forward(6))  ## each mean with the averave succeeding
}
\seealso{
The \code{MASS} function \code{\link[MASS]{contr.sdif}} which is an early
   version of \code{code_deviation} (by the same author).
}
