% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/common_tools.R
\name{BGFA_cocoreg_interface}
\alias{BGFA_cocoreg_interface}
\title{Apply GFA using the same interface as cocoreg()}
\usage{
BGFA_cocoreg_interface(df_list, K = 8, Nrep = 2, threshold = 0.001)
}
\arguments{
\item{df_list}{[1,m] list of data.frames, Input data to GFA in COCOREG format}

\item{K}{[1,1] int, (Maximum) number of GFA components}

\item{Nrep}{[1,1] int, Number of random initializatin used for learning the model}

\item{threshold}{[1,1] double, GFA model trimming threshold}
}
\value{
A list with elements:
\item{$data:}{[1,m] list of data.frames, Original data reconstructed using only
        those latent components that are active in all datasets}
\item{$model:}{a list, Non-trimmed output of CCAGFA::GFA()}
\item{$dataid:}{string, Dataset identifier string}
\item{$method:}{string, Analysis method identifier string}
\item{$wall_time_taken:}{[1,1] double, Time taken to run the analysis in seconds}
}
\description{
Note: if K is too high GFA() might not converge in a meaningful time
or the computation may mysteriously crash.
}

