\name{bal.tab.mimids}
\alias{bal.tab.mimids}
\alias{bal.tab.wimids}
\title{
Balance Statistics for MatchThem Objects
}
\description{
Generates balance statistics for \code{mimids} and \code{wimids} objects from \pkg{MatchThem}.
}
\usage{
\method{bal.tab}{mimids}(mimids, 
    int = FALSE, 
    poly = 1, 
    distance = NULL, 
    addl = NULL, 
    data = NULL, 
    continuous,  
    binary, 
    s.d.denom, 
    m.threshold = NULL, 
    v.threshold = NULL, 
    ks.threshold = NULL,
    cluster = NULL, 
    abs = FALSE,
    subset = NULL,
    quick = TRUE, 
    ...)

\method{bal.tab}{wimids}(wimids, 
    int = FALSE, 
    poly = 1, 
    distance = NULL, 
    addl = NULL, 
    data = NULL, 
    continuous,  
    binary, 
    s.d.denom, 
    m.threshold = NULL, 
    v.threshold = NULL, 
    ks.threshold = NULL,
    r.threshold = NULL,
    cluster = NULL, 
    pairwise = TRUE, 
    focal = NULL, 
    abs = FALSE,
    subset = NULL,
    quick = TRUE, 
    ...)
}

\arguments{
  \item{mimids, wimids}{
a \code{mimids} or \code{wimids} object; the output of a call to \code{matchthem()} or \code{weightthem()} from the \pkg{MatchThem} package.
}
  \item{int}{
\code{logical} or \code{numeric}; whether or not to include 2-way interactions of covariates included in \code{covs} and in \code{addl}. If \code{numeric}, will be passed to \code{poly} as well. In older versions of \pkg{cobalt}, setting \code{int = TRUE} displayed squares of covariates; to replicate this behavior, set \code{int = 2}.
}
  \item{poly}{
\code{numeric}; the highest polynomial of each continuous covariate to display. For example, if 2, squares of each continuous covariate will be displayed (in addition to the covariate itself); if 3, squares and cubes of each continuous covariate will be displayed, etc. If 1, the default, only the base covariate will be displayed. If \code{int} is numeric, \code{poly} will take on the value of \code{int}.
}
  \item{distance}{
Optional; either a vector or data.frame containing distance values (e.g., propensity scores) for each unit or a string containing the name of the distance variable in \code{data}. Note that the distance measure generated by \code{matchthem()} or \code{weightthem()} is automatically included.
}
  \item{addl}{
an optional data frame or the quoted names of additional covariates for which to present balance. These may be covariates included in the original dataset but not included in the call to \code{matchthem()} or \code{weightthem()}. If variable names are specified, \code{bal.tab()} will look first in the argument to \code{data}, if specified, and next in the \code{mimids} or \code{wimids} object.
}
  \item{data}{
an optional data frame or \code{mids} object containing variables that might be named in arguments to \code{distance}, \code{addl}, and \code{cluster}. See Examples.
}
  \item{continuous}{
whether mean differences for continuous variables should be standardized ("std") or raw ("raw"). Default "std". Abbreviations allowed. This option can be set globally using \code{\link{set.cobalt.options}}.
}
  \item{binary}{
whether mean differences for binary variables (i.e., difference in proportion) should be standardized ("std") or raw ("raw"). Default "raw". Abbreviations allowed. This option can be set globally using \code{\link{set.cobalt.options}}.
}
  \item{s.d.denom}{
whether the denominator for standardized differences (if any are calculated) should be the standard deviation of the treated group ("treated"), the standard deviation of the control group ("control"), the pooled standard deviation ("pooled", computed as the square root of the mean of the group variances), or the standard deviation in the full sample ("all"). Abbreviations allowed. The defaults depend on the options specified in the original function calls; see \code{\link{bal.tab.matchit}} and \code{\link{bal.tab.weightit}} for details on the defaults.
}
  \item{m.threshold}{
a numeric value for the threshold for mean differences. 
}
  \item{v.threshold}{
a numeric value for the threshold for variance ratios. Will automatically convert to the inverse if less than 1.
}
  \item{ks.threshold}{
a numeric value for the threshold for Kolmogorov-Smirnov statistics. Must be between 0 and 1. 
}
  \item{r.threshold}{
a numeric value for the threshold for correlations between covariates and treatment when treatment is continuous.
}
  \item{cluster}{
either a vector containing cluster membership for each unit or a string containing the name of the cluster membership variable in \code{data} or the \code{mimids} or \code{wimids} object. See \code{\link{bal.tab.cluster}} for details.
}
  \item{pairwise}{
whether balance should be computed for pairs of treatments or for each treatment against all others combined. See \code{\link{bal.tab.multi}} for details. 
}
  \item{focal}{
Currently ignored.
}
  \item{abs}{
\code{logical}; whether displayed balance statistics should be in absolute value or not. 
}
  \item{subset}{
a \code{logical} vector denoting whether each observation should be included. It should be the same length as the variables in the original (unimputed) dataset or the call to \code{matchthem()} or \code{weightthem()} (i.e., one for each individual or one for each individual for each imputation). \code{NA}s will be treated as \code{FALSE}. This can be used as an alternative to \code{cluster} to examine balance on subsets of the data. For multinomial treatments, this can be used to subset treatment level pairs.
}
  \item{quick}{
\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Set to \code{FALSE} if computed values not displayed will be used later.
}
  \item{...}{
further arguments to control display of output. See \link[=options-display]{display options} for details.
}
}
\details{
\code{bal.tab.mimids()} and \code{bal.tab.wimids()} generate a list of balance summaries for the \code{mimids} or \code{wimids} object given.

The threshold values (\code{m.threshold}, \code{v.threshold}, and \code{ks.threshold}) control whether extra columns should be inserted into the Balance table describing whether the balance statistics in question exceeded or were within the threshold. Including these thresholds also creates summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure.

}
\value{
If clusters are not specified, an object of class \code{"bal.tab.imp"} containing balance summaries for each imputation and a summary of balance across imputations. See \code{\link{bal.tab.imp}} for details.

If clusters are specified, an object of class \code{"bal.tab.imp.cluster"} containing summaries between and across all clusters and imputations.
}

\author{
Noah Greifer 
}

\seealso{
\code{\link{bal.tab}} for details of calculations.
}
\examples{
library(MatchThem)
library(mice)
data("lalonde_mis", package = "cobalt")

#Imputing the missing data
imp <- mice(lalonde_mis, m = 5)

#Matching using within-imputation propensity scores
mt.out1 <- matchthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "within")
bal.tab(mt.out1)

\dontrun{
#Matching using across-imputation average propensity scores
mt.out2 <- matchthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "across")
bal.tab(mt.out2)
}

#Weighting using within-imputation propensity scores
wt.out <- weightthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "within",
                       estimand = "ATT")
bal.tab(wt.out)

}
\keyword{tables}