% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saint-lague-scheppers.R
\name{sls}
\alias{sls}
\title{Seat Distribution by Sainte-Lague/Schepers}
\usage{
sls(votes, parties, n_seats = 598L)
}
\arguments{
\item{votes}{A numeric vector giving the redistributes votes}

\item{parties}{A character vector indicating the names of parties with
respective \code{votes}.}

\item{n_seats}{The total number of seats that can be assigned to the different
parties.}
}
\value{
A numeric vector giving the number of seats each party obtained.
}
\description{
Calculates number of seats for the respective parties that have received more
than 5\% of votes (according to the method of Sainte-Lague/Schepers,
see https://www.wahlrecht.de/verfahren/rangmasszahlen.html).
}
\examples{
library(coalitions)
library(dplyr) 
# get the latest survey for the sample German federal election polls
surveys <- get_latest(surveys_sample) \%>\% tidyr::unnest()
# calculate the seat distribution based on Sainte-Lague/Schepers for a parliament with 300 seats
sls(surveys$votes, surveys$party, n_seats = 300)
}
\seealso{
\code{\link{dHondt}}
}
