% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revolution-solid.R
\name{revolution-solid}
\alias{revolution-solid}
\alias{shellmethod}
\alias{discmethod}
\title{Volumes of solids of revolution}
\usage{
shellmethod(f, a, b)

discmethod(f, a, b)
}
\arguments{
\item{f}{function of revolution}

\item{a}{lower-bound of the solid}

\item{b}{upper-bound of the solid}
}
\value{
the volume of the solid
}
\description{
Find the volume of a solid of revolution
}
\details{
The functions \code{discmethod} and \code{shellmethod} implement the
algorithms for finding the volume of solids of revolution.  The
\code{discmethod} function is suitable for volumes revolved around
the \code{x}-axis and the \code{shellmethod} function is suitable for
volumes revolved around the \code{y}-axis.
}
\examples{
f <- function(x) { x^2 }
shellmethod(f, 1, 2)
discmethod(f, 1, 2)

}
\seealso{
Other integration: \code{\link{adaptint}},
  \code{\link{gaussint}}, \code{\link{giniquintile}},
  \code{\link{mcint}}, \code{\link{midpt}},
  \code{\link{romberg}}, \code{\link{simp38}},
  \code{\link{simp}}, \code{\link{trap}}
}
