% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{ccosine}
\alias{ccosine}
\title{Calculate the Cosine distance of a factor in a dataframe.}
\usage{
ccosine(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Cosine Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{The factor which you want to calculate the Cosine distances matrix.}

\item{plot}{If TRUE, shows a plot of the Cosine distances matrix.}

\item{plot_title}{The title of the plot.}
}
\value{
The matrix containing distances.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Cosine distances about it.
}
\details{
Calculate Cosine distance
}
\examples{

# Example with iris dataset

ccosine(iris, ~Species, plot = TRUE, plot_title = "Cosine Distance Between Groups")

# Example with mtcars dataset

ccosine(mtcars, ~am, plot = TRUE, plot_title = "Cosine Distance Between Groups")

}
