% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cmaRs.R
\name{predict.cmaRs}
\alias{predict.cmaRs}
\title{A prediction function for a new data set for prediction purpose}
\usage{
\method{predict}{cmaRs}(object, new = NULL, ...)
}
\arguments{
\item{object}{A cmaRs object which is obtained by prediction.}

\item{new}{The data for which the fitted values will be constructed.}

\item{...}{Additional parameters affecting the predictions.}
}
\value{
y The predicted values.
}
\description{
This function allows you to obtain the predicted values of a CMARS model.
}
\examples{
\dontrun{
# Without \code{MOSEK}, the example code is not executable.
# For installation of Mosek, plese see the documentation of 'Rmosek'.
data("trees", package = "earth")
model.prediction <- cmaRs(Volume~., degree = 5, nk = 20, data = trees)
predict.cmaRs(model.prediction, data = trees)}
}
