% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_object-getters.R
\name{get_cutoff}
\alias{get_cutoff}
\title{Get Cutoff}
\usage{
get_cutoff(cluster_data)
}
\arguments{
\item{cluster_data}{The output from the `cluster()` function.}
}
\value{
the cutoff value as a `dbl`
}
\description{
Returns the distance cutoff of the cluster object from the `cluster()`
function
}
\examples{
cutoff <- 0.2
count_table <- read_count(example_path("amazon.full.count_table"))
distance_data <- read_dist(example_path("amazon_column.dist"),
                           count_table, cutoff, FALSE)
df_clusters <- cluster(distance_data, cutoff, method = "opticlust")
cutoff <- get_cutoff(df_clusters)
}
